/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.messaging;

import java.util.Map;
import java.util.logging.Logger;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.core.Listener;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.mechio.api.motion.AbstractRobot;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.JointProperty;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.messaging.RemoteJoint;
import org.mechio.api.motion.messaging.RemoteRobotClient;
import org.mechio.api.motion.protocol.DefaultMotionFrame;
import org.mechio.api.motion.protocol.RobotDefinitionResponse;

public class RemoteRobot
extends AbstractRobot<RemoteJoint> {
    private static final Logger theLogger = Logger.getLogger(RemoteRobot.class.getName());
    private RemoteRobotClient myRobotClient;
    private Robot.RobotPositionMap myPreviousPositions;
    private MessageAsyncReceiver<RobotDefinitionResponse> myDefinitionReceiver;
    private Listener<RobotDefinitionResponse> myDefinitionListener;

    public RemoteRobot(RemoteRobotClient client, MessageAsyncReceiver<RobotDefinitionResponse> definitionReceiver) {
        super(client.getRobotId());
        this.myRobotClient = client;
        this.myDefinitionReceiver = definitionReceiver;
        this.updateRobotDefinition();
        this.myDefinitionListener = new Listener<RobotDefinitionResponse>(){

            public void handleEvent(RobotDefinitionResponse t) {
                RemoteRobot.this.syncRobotDefinition(t);
            }
        };
        this.myDefinitionReceiver.addListener(this.myDefinitionListener);
    }

    private void updateRobotDefinition() {
        RobotDefinitionResponse robotDef = this.myRobotClient.requestRobotDefinition();
        this.updateRobotDefinition(robotDef);
    }

    private void updateRobotDefinition(RobotDefinitionResponse robotDef) {
        if (robotDef == null) {
            theLogger.warning("RobotRequest timed out.  Unable to update definition.");
            throw new NullPointerException();
        }
        for (RobotDefinitionResponse.JointDefinition def : robotDef.getJointDefinitions()) {
            RemoteJoint rj = new RemoteJoint(this, def);
            this.addJoint(rj);
        }
    }

    private boolean updateJoint(RobotDefinitionResponse.JointDefinition j) {
        NormalizedDouble goalPosition;
        boolean found = false;
        RemoteJoint joint = null;
        Joint.Id jId = j.getJointId();
        Robot.JointId jointId = new Robot.JointId(this.getRobotId(), jId);
        if (this.myJointMap.containsKey(jointId)) {
            joint = (RemoteJoint)this.myJointMap.get(jointId);
            found = true;
        }
        if (!found || joint == null) {
            return false;
        }
        boolean enabled = j.getEnabled();
        if (enabled != joint.getEnabled()) {
            joint.setEnabled(enabled);
        }
        if (!(goalPosition = j.getGoalPosition()).equals((Object)joint.getGoalPosition())) {
            joint.setGoalPosition(goalPosition);
        }
        for (RobotDefinitionResponse.JointPropDefinition prop : j.getJointProperties()) {
            JointProperty jointProp = joint.getProperty(prop.getPropertyName());
            Double initialValue = prop.getInitialValue();
            if (initialValue.equals(jointProp.getValue())) continue;
            jointProp.setValue(initialValue);
        }
        return true;
    }

    private void syncRobotDefinition(RobotDefinitionResponse robotDef) {
        if (robotDef == null) {
            theLogger.warning("RobotRequest timed out.  Unable to update definition.");
            throw new NullPointerException();
        }
        for (RobotDefinitionResponse.JointDefinition def : robotDef.getJointDefinitions()) {
            this.updateJoint(def);
        }
    }

    public boolean updateRobot() {
        try {
            this.updateRobotDefinition();
        }
        catch (NullPointerException ex) {
            return false;
        }
        return true;
    }

    @Override
    public boolean connect() {
        Boolean ret = this.myRobotClient.sendConnect();
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to connect.");
            return false;
        }
        return ret;
    }

    @Override
    public void disconnect() {
        Boolean ret = this.myRobotClient.sendDisconnect();
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to disconnect.");
        } else {
            this.myDefinitionReceiver.removeListener(this.myDefinitionListener);
        }
    }

    @Override
    public boolean isConnected() {
        Boolean ret = this.myRobotClient.getConnected();
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to get connection status.");
            return false;
        }
        return ret;
    }

    @Override
    public void setEnabled(boolean val) {
        Boolean ret = val ? this.myRobotClient.sendEnable() : this.myRobotClient.sendDisable();
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to set enabled value.");
        }
    }

    @Override
    public boolean isEnabled() {
        Boolean ret = this.myRobotClient.getEnabled();
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to get enabled status.");
            return false;
        }
        return ret;
    }

    boolean setJointEnabled(Robot.JointId jId, boolean val) {
        Boolean ret = val ? this.myRobotClient.sendJointEnable(jId) : this.myRobotClient.sendJointDisable(jId);
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to get joint enabled confirmation.");
            return false;
        }
        return ret;
    }

    boolean getJointEnabled(Robot.JointId jId) {
        Boolean ret = this.myRobotClient.getJointEnabled(jId);
        if (ret == null) {
            theLogger.warning("RobotRequest timed out.  Unable to get joint enabled status.");
        }
        return ret;
    }

    @Override
    public void move(Robot.RobotPositionMap positions, long lenMillisec) {
        DefaultMotionFrame<Robot.RobotPositionMap> frame = new DefaultMotionFrame<Robot.RobotPositionMap>();
        frame.setFrameLengthMillisec(lenMillisec);
        frame.setGoalPositions(positions);
        frame.setPreviousPositions(this.myPreviousPositions);
        frame.setTimestampMillisecUTC(TimeUtils.now());
        this.myRobotClient.sendMovement(frame);
        this.myPreviousPositions = positions;
        this.setGoals(this.myPreviousPositions);
    }

    private void setGoals(Robot.RobotPositionMap goals) {
        for (Map.Entry e : goals.entrySet()) {
            Robot.JointId jId = (Robot.JointId)e.getKey();
            NormalizedDouble val = (NormalizedDouble)e.getValue();
            RemoteJoint j = (RemoteJoint)this.getJoint(jId);
            if (j == null) continue;
            j.setGoalPosition(val);
        }
    }

    public void setDefinitionReceiver(MessageAsyncReceiver<RobotDefinitionResponse> receiver) {
        if (this.isConnected()) {
            this.myDefinitionReceiver.removeListener(this.myDefinitionListener);
        }
        this.myDefinitionReceiver = receiver;
        if (this.isConnected() && this.myDefinitionReceiver != null) {
            this.myDefinitionReceiver.addListener(this.myDefinitionListener);
        }
    }
}

