/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jflux.api.common.rk.property.PropertyChangeNotifier;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.utils.RobotController;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class RobotManager
extends PropertyChangeNotifier {
    public static final String PROP_ADD_ROBOT = "addRobot";
    public static final String PROP_REMOVE_ROBOT = "removeRobot";
    private Map<Robot.Id, RobotController> myControllerMap;
    private Map<Robot.Id, ServiceRegistration> myRegistrationMap;
    private List<RobotController> myControllerList;

    public RobotManager(BundleContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.myControllerMap = new HashMap<Robot.Id, RobotController>();
        this.myRegistrationMap = new HashMap<Robot.Id, ServiceRegistration>();
        this.myControllerList = new ArrayList<RobotController>();
    }

    public void addRobot(Robot robot) {
        if (robot == null || robot.getRobotId() == null) {
            throw new NullPointerException();
        }
        if (this.myControllerMap.containsKey(robot.getRobotId())) {
            return;
        }
        RobotController controller = new RobotController(this);
        controller.setRobot(robot);
        this.myControllerMap.put(robot.getRobotId(), controller);
        this.myControllerList.add(controller);
        int index = this.myControllerList.indexOf(controller);
        this.fireIndexedPropertyChange(PROP_ADD_ROBOT, index, null, controller);
    }

    public void removeRobot(Robot.Id robotId) {
        ServiceRegistration reg;
        RobotController rc = this.myControllerMap.remove(robotId);
        int index = -1;
        if (rc != null) {
            rc.disconnectRobot();
            index = this.myControllerList.indexOf(rc);
            this.myControllerList.remove(rc);
        }
        if ((reg = this.myRegistrationMap.remove(robotId)) != null) {
            reg.unregister();
        }
        this.fireIndexedPropertyChange(PROP_REMOVE_ROBOT, index, null, rc);
    }

    public Map<Robot.Id, RobotController> getControllerMap() {
        return this.myControllerMap;
    }

    public List<RobotController> getControllers() {
        return this.myControllerList;
    }
}

