/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.blending;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jflux.api.common.rk.utils.TimerLoop;
import org.mechio.api.motion.blending.Blender;
import org.mechio.api.motion.blending.FrameSource;
import org.mechio.api.motion.blending.FrameSourceTracker;
import org.mechio.api.motion.protocol.MotionFrame;

public class TimedBlenderDriver
extends TimerLoop {
    private Blender myBlender;
    private FrameSourceTracker mySourceTracker;

    public TimedBlenderDriver(long interval) {
        super(interval);
    }

    public void setBlender(Blender blender) {
        this.myBlender = blender;
    }

    public void setFrameSourceTracker(FrameSourceTracker tracker) {
        this.mySourceTracker = tracker;
    }

    public FrameSourceTracker getFrameSourceTracker() {
        return this.mySourceTracker;
    }

    protected void timerTick(long time, long interval) {
        if (this.mySourceTracker == null || this.myBlender == null) {
            return;
        }
        List<FrameSource> sources = this.mySourceTracker.getSources();
        if (sources == null || sources.isEmpty()) {
            return;
        }
        Map<MotionFrame, FrameSource> frames = this.collectFrames(time, interval, sources);
        this.myBlender.blend(time, interval, frames);
    }

    private Map<MotionFrame, FrameSource> collectFrames(long time, long interval, List<FrameSource> sources) {
        HashMap<MotionFrame, FrameSource> frames = new HashMap<MotionFrame, FrameSource>();
        for (FrameSource source : sources) {
            MotionFrame frame = source.getMovements(time, interval);
            if (frame == null) continue;
            frames.put(frame, source);
        }
        return frames;
    }
}

