/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.lifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.jflux.api.common.rk.utils.Utils;
import org.jflux.api.core.Source;
import org.jflux.impl.services.rk.lifecycle.ServiceLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceFactory;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceGroup;
import org.jflux.impl.services.rk.lifecycle.utils.SimpleLifecycle;
import org.jflux.impl.services.rk.osgi.OSGiUtils;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponentFactory;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.blending.FrameCombiner;
import org.mechio.api.motion.blending.FrameSourceTracker;
import org.mechio.api.motion.blending.NaiveMotionFrameAverager;
import org.mechio.api.motion.blending.OSGiFrameSourceTracker;
import org.mechio.api.motion.lifecycle.RobotBlenderLifecycle;
import org.mechio.api.motion.lifecycle.RobotOutputLifecycle;
import org.mechio.api.motion.lifecycle.TimedBlenderDriverLifecycle;
import org.osgi.framework.BundleContext;

public class DefaultBlenderServiceGroup
extends ManagedServiceGroup {
    private static final Logger theLogger = Logger.getLogger(DefaultBlenderServiceGroup.class.getName());

    private static String getIdBase(Robot.Id robotId) {
        String base = "robot/" + robotId + "/blender";
        return base;
    }

    public DefaultBlenderServiceGroup(BundleContext context, Robot.Id robotId, long blenderIntervalMillisec, Properties registrationProperties) {
        super((ManagedServiceFactory)new OSGiComponentFactory(context), DefaultBlenderServiceGroup.getBlenderLifecycles(context, robotId, blenderIntervalMillisec), DefaultBlenderServiceGroup.getIdBase(robotId), registrationProperties);
    }

    private static List<ServiceLifecycleProvider> getBlenderLifecycles(BundleContext context, Robot.Id robotId, long blenderInterval) {
        blenderInterval = DefaultBlenderServiceGroup.validateInterval(blenderInterval);
        ArrayList<ServiceLifecycleProvider> services = new ArrayList<ServiceLifecycleProvider>();
        services.add((ServiceLifecycleProvider)new RobotBlenderLifecycle(robotId));
        services.add((ServiceLifecycleProvider)new RobotOutputLifecycle(robotId));
        services.add((ServiceLifecycleProvider)new TimedBlenderDriverLifecycle(robotId, blenderInterval));
        services.add(DefaultBlenderServiceGroup.buildFrameSourceTrackerLauncher(context, robotId));
        services.add(DefaultBlenderServiceGroup.buildFrameCombinerLauncher(robotId));
        return services;
    }

    private static long validateInterval(long interval) {
        return Utils.bound((long)interval, (long)1L, (long)0x7FFFFFFEL);
    }

    private static ServiceLifecycleProvider<FrameSourceTracker> buildFrameSourceTrackerLauncher(BundleContext context, Robot.Id robotId) {
        Properties props = new Properties();
        props.put("robotId", robotId.getRobtIdString());
        OSGiFrameSourceTracker tracker = new OSGiFrameSourceTracker();
        tracker.init(context, OSGiUtils.createServiceFilter((Properties)props));
        props.put("positionMapType", Robot.RobotPositionMap.class.getName());
        return new SimpleLifecycle((Object)tracker, FrameSourceTracker.class, props);
    }

    private static ServiceLifecycleProvider<FrameCombiner> buildFrameCombinerLauncher(Robot.Id robotId) {
        Properties props = new Properties();
        props.put("robotId", robotId.getRobtIdString());
        props.put("positionMapType", Robot.RobotPositionMap.class.getName());
        return new SimpleLifecycle((Object)DefaultBlenderServiceGroup.getFrameCombiner(), FrameCombiner.class, props);
    }

    private static FrameCombiner getFrameCombiner() {
        Source<Robot.RobotPositionMap> factory = new Source<Robot.RobotPositionMap>(){

            public Robot.RobotPositionMap getValue() {
                return new Robot.RobotPositionHashMap();
            }
        };
        return new NaiveMotionFrameAverager(factory);
    }
}

