/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.servos.config;

import org.jflux.api.common.rk.property.PropertyChangeNotifier;
import org.mechio.api.motion.servos.config.ServoConfig;

public class DefaultServoConfig<Id>
extends PropertyChangeNotifier
implements ServoConfig<Id> {
    private Id myServoId;
    private String myName;
    private int myMinPosition;
    private int myMaxPosition;
    private int myDefaultPosition;

    public DefaultServoConfig(Id servoId, String name, int minPos, int maxPos, int defPos) {
        this.myServoId = servoId;
        this.myName = name;
        this.myMinPosition = minPos;
        this.myMaxPosition = maxPos;
        this.checkAbsPosition(defPos);
        this.myDefaultPosition = defPos;
    }

    @Override
    public Id getServoId() {
        return this.myServoId;
    }

    @Override
    public void setServoId(Id id) {
        if (id == null) {
            throw new NullPointerException("Cannot set null Servo id.");
        }
        Id oldId = this.myServoId;
        this.myServoId = id;
        this.firePropertyChange("logicalId", oldId, id);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(String name) {
        String oldName = this.myName;
        this.myName = name;
        this.firePropertyChange("name", oldName, name);
    }

    @Override
    public int getMinPosition() {
        return this.myMinPosition;
    }

    @Override
    public void setMinPosition(Integer pos) {
        if (pos == null) {
            throw new NullPointerException("Cannot set null position.");
        }
        Integer oldPos = this.myMinPosition;
        this.myMinPosition = pos;
        this.firePropertyChange("minPosition", oldPos, pos);
    }

    @Override
    public int getMaxPosition() {
        return this.myMaxPosition;
    }

    @Override
    public void setMaxPosition(Integer pos) {
        if (pos == null) {
            throw new NullPointerException("Cannot set null position.");
        }
        Integer oldPos = this.myMaxPosition;
        this.myMaxPosition = pos;
        this.firePropertyChange("maxPosition", oldPos, pos);
    }

    @Override
    public int getDefaultPosition() {
        return this.myDefaultPosition;
    }

    @Override
    public void setDefaultPosition(Integer pos) {
        if (pos == null) {
            throw new NullPointerException("Cannot set null position.");
        }
        this.checkAbsPosition(pos);
        Integer oldPos = this.myDefaultPosition;
        this.myDefaultPosition = pos;
        this.firePropertyChange("defaultPosition", oldPos, pos);
    }

    private void checkAbsPosition(int pos) {
        int max = Math.max(this.myMinPosition, this.myMaxPosition);
        int min = Math.min(this.myMinPosition, this.myMaxPosition);
        if (pos < min || pos > max) {
            throw new IllegalArgumentException("Position (" + pos + ") out of range [" + min + ", " + max + "].");
        }
    }
}

