/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.servos.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.servos.ServoController;

public final class JointServoMap {
    private static final Logger theLogger = Logger.getLogger(JointServoMap.class.getName());
    private List<Joint.Id> myJointIds = new ArrayList<Joint.Id>();
    private Map<Joint.Id, ServoController.ServoId<String>> myJointMap = new HashMap<Joint.Id, ServoController.ServoId<String>>();
    private Map<ServoController.ServoId<String>, Joint.Id> myServoMap = new HashMap<ServoController.ServoId<String>, Joint.Id>();
    private Map<ServoController.Id, List<ServoController.ServoId<String>>> myControllerMap = new HashMap<ServoController.Id, List<ServoController.ServoId<String>>>();

    public void addServoId(Joint.Id jointId, ServoController.Id controllerId, String servoId) {
        if (this.myJointMap.containsKey(jointId)) {
            theLogger.log(Level.WARNING, "Unable to add servo id, Joint id already exists. joint: {0}, controller: {1}, servo {2}", new Object[]{jointId, controllerId, servoId});
            return;
        }
        ServoController.ServoId<String> id = new ServoController.ServoId<String>(controllerId, servoId);
        if (this.myServoMap.containsKey(id)) {
            theLogger.log(Level.WARNING, "Unable to add servo id, already in use. joint: {0}, controller: {1}, servo {2}", new Object[]{jointId, controllerId, servoId});
            return;
        }
        this.myJointIds.add(jointId);
        this.myJointMap.put(jointId, id);
        this.myServoMap.put(id, jointId);
        List<ServoController.ServoId<String>> ids = this.myControllerMap.get(controllerId);
        if (ids == null) {
            ids = new ArrayList<ServoController.ServoId<String>>();
            this.myControllerMap.put(controllerId, ids);
        }
        ids.add(id);
    }

    public List<Joint.Id> getJointIds() {
        return this.myJointIds;
    }

    public List<ServoController.ServoId<String>> getServoIds(ServoController.Id controllerId) {
        return this.myControllerMap.get(controllerId);
    }
}

