/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.utils;

import java.util.Map;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.protocol.DefaultMotionFrame;
import org.mechio.api.motion.protocol.MotionFrame;
import org.mechio.api.motion.utils.RobotFrameSource;
import org.osgi.framework.BundleContext;

public class PositionTargetFrameSource
implements RobotFrameSource {
    private Robot.RobotPositionMap myTargetPositions = new Robot.RobotPositionHashMap();
    private BundleContext myContext;
    private double myVelocity;
    private boolean myEnabledFlag;
    private boolean myStopOnGoalFlag;
    private Robot myRobot;

    public PositionTargetFrameSource(double velocity, Robot.RobotPositionMap targetPositions) {
        if (targetPositions != null) {
            this.myTargetPositions.putAll((Map)((Object)targetPositions));
        }
        this.myVelocity = velocity;
        this.myEnabledFlag = true;
        this.myStopOnGoalFlag = true;
    }

    @Override
    public void setRobot(Robot robot) {
        this.myRobot = robot;
    }

    @Override
    public Robot getRobot() {
        return this.myRobot;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabledFlag = enabled;
    }

    public boolean getEnabled() {
        return this.myEnabledFlag;
    }

    public void setVelocity(double velocity) {
        if (velocity < 0.0) {
            return;
        }
        this.myVelocity = velocity;
    }

    public double getVelocity() {
        return this.myVelocity;
    }

    public void setStopOnGoal(boolean val) {
        this.myStopOnGoalFlag = val;
    }

    public boolean getStopOnGoalFlag() {
        return this.myStopOnGoalFlag;
    }

    public void putPositions(Robot.RobotPositionMap targetPositions) {
        if (targetPositions == null) {
            return;
        }
        if (this.positionsEqual(targetPositions)) {
            return;
        }
        this.myTargetPositions.putAll((Map)((Object)targetPositions));
        this.setEnabled(true);
    }

    private boolean positionsEqual(Robot.RobotPositionMap targetPositions) {
        if (this.myTargetPositions.size() < targetPositions.size()) {
            return false;
        }
        for (Map.Entry e : targetPositions.entrySet()) {
            NormalizedDouble newVal;
            Robot.JointId id = (Robot.JointId)e.getKey();
            NormalizedDouble val = (NormalizedDouble)e.getValue();
            if (id == null || val == null || val.equals((Object)(newVal = (NormalizedDouble)this.myTargetPositions.get(id)))) continue;
            return false;
        }
        return true;
    }

    public void putPosition(Robot.JointId id, NormalizedDouble position) {
        this.myTargetPositions.put(id, position);
        this.setEnabled(true);
    }

    public void clearPositions() {
        this.myTargetPositions.clear();
        this.setEnabled(false);
    }

    @Override
    public MotionFrame getMovements(long time, long interval) {
        if (this.myRobot == null || this.myTargetPositions == null || !this.myEnabledFlag || this.myVelocity <= 0.0) {
            return null;
        }
        Robot.RobotPositionMap currentPos = this.myRobot.getCurrentPositions();
        if (currentPos == null || currentPos.isEmpty()) {
            return null;
        }
        Robot.RobotPositionHashMap goals = new Robot.RobotPositionHashMap();
        DefaultMotionFrame<Robot.RobotPositionHashMap> frame = new DefaultMotionFrame<Robot.RobotPositionHashMap>();
        frame.setTimestampMillisecUTC(time);
        frame.setFrameLengthMillisec(interval);
        for (Map.Entry e : currentPos.entrySet()) {
            Robot.JointId id = (Robot.JointId)e.getKey();
            NormalizedDouble cur = (NormalizedDouble)e.getValue();
            NormalizedDouble goal = (NormalizedDouble)this.myTargetPositions.get(id);
            if (goal == null || cur == null) continue;
            int sign = goal.compareTo((Object)cur) >= 0 ? 1 : -1;
            Double newPos = cur.getValue() + (double)interval * this.myVelocity * (double)sign;
            if (!NormalizedDouble.isValid((double)newPos)) continue;
            NormalizedDouble pos = new NormalizedDouble(newPos.doubleValue());
            pos = sign > 0 ? (pos.compareTo((Object)goal) < 0 ? pos : goal) : (pos.compareTo((Object)goal) > 0 ? pos : goal);
            goals.put(id, pos);
        }
        if (goals.isEmpty()) {
            return null;
        }
        if (this.myStopOnGoalFlag) {
            this.disableAtGoal();
        }
        frame.setGoalPositions(goals);
        return frame;
    }

    protected void disableAtGoal() {
        if (this.isAtGoal()) {
            this.setEnabled(false);
        }
    }

    protected boolean isAtGoal() {
        Robot.RobotPositionMap currentGoals = this.myRobot.getGoalPositions();
        if (currentGoals == null || currentGoals.isEmpty()) {
            return true;
        }
        boolean atGoal = true;
        for (Map.Entry e : currentGoals.entrySet()) {
            NormalizedDouble curGoal = (NormalizedDouble)e.getValue();
            NormalizedDouble target = (NormalizedDouble)this.myTargetPositions.get(e.getKey());
            if (target == null || curGoal == null) continue;
            atGoal = atGoal && target.equals((Object)curGoal);
        }
        return atGoal;
    }
}

