/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.blending;

import java.util.Map;
import java.util.logging.Logger;
import org.mechio.api.motion.blending.Blender;
import org.mechio.api.motion.blending.BlenderOutput;
import org.mechio.api.motion.blending.FrameCombiner;
import org.mechio.api.motion.blending.FrameSource;
import org.mechio.api.motion.protocol.JointPositionMap;
import org.mechio.api.motion.protocol.MotionFrame;

public class DefaultBlender<MF extends MotionFrame<PosMap>, FS extends FrameSource<PosMap>, PosMap extends JointPositionMap>
implements Blender<MF, FS, PosMap> {
    private static final Logger theLogger = Logger.getLogger(DefaultBlender.class.getName());
    private FrameCombiner<MF, FS, PosMap> myFrameCombiner;
    private BlenderOutput<PosMap> myOutput;

    @Override
    public void setFrameCombiner(FrameCombiner<MF, FS, PosMap> combiner) {
        this.myFrameCombiner = combiner;
    }

    @Override
    public FrameCombiner<MF, FS, PosMap> getFrameCombiner() {
        return this.myFrameCombiner;
    }

    @Override
    public void setOutput(BlenderOutput<PosMap> out) {
        this.myOutput = out;
    }

    @Override
    public void blend(long time, long interval, Map<? extends MF, ? extends FS> frames) {
        if (frames == null || frames.isEmpty() || this.myFrameCombiner == null || this.myOutput == null) {
            return;
        }
        PosMap curPos = this.myOutput.getPositions();
        if (curPos == null || curPos.isEmpty()) {
            return;
        }
        PosMap pos = this.myFrameCombiner.combineFrames(time, interval, curPos, frames);
        this.myOutput.write(pos, interval);
    }
}

