/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.jointgroup;

import java.util.ArrayList;
import java.util.List;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.services.ServiceFactory;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.jointgroup.JointGroup;
import org.mechio.api.motion.jointgroup.RobotJointGroup;
import org.mechio.api.motion.jointgroup.RobotJointGroupConfig;

public class RobotJointGroupFactory
implements ServiceFactory<JointGroup, RobotJointGroupConfig> {
    public static RobotJointGroup buildGroup(RobotJointGroupConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        ArrayList<RobotJointGroup> jointGroups = new ArrayList<RobotJointGroup>(config.getGroupCount());
        for (RobotJointGroupConfig child : config.getJointGroups()) {
            RobotJointGroup djg = RobotJointGroupFactory.buildGroup(child);
            if (djg == null) continue;
            jointGroups.add(djg);
        }
        String name = config.getName();
        List<Robot.JointId> ids = config.getJointIds();
        return new RobotJointGroup(name, ids, (List<RobotJointGroup>)jointGroups);
    }

    public VersionProperty getServiceVersion() {
        return RobotJointGroup.VERSION;
    }

    public JointGroup build(RobotJointGroupConfig config) {
        return RobotJointGroupFactory.buildGroup(config);
    }

    public Class<JointGroup> getServiceClass() {
        return JointGroup.class;
    }

    public Class<RobotJointGroupConfig> getConfigurationClass() {
        return RobotJointGroupConfig.class;
    }
}

