/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.lifecycle;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.impl.services.rk.lifecycle.AbstractLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.DescriptorListBuilder;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.messaging.RemoteRobot;
import org.mechio.api.motion.messaging.RemoteRobotClient;
import org.mechio.api.motion.protocol.RobotDefinitionResponse;

public class RemoteRobotLifecycle
extends AbstractLifecycleProvider<Robot, RemoteRobot> {
    private static final Logger theLogger = Logger.getLogger(RemoteRobotLifecycle.class.getName());
    private static final String theRobotClient = "remoteRobotClient";
    private static final String theDefReceiver = "robotDefinitionReceiver";

    public RemoteRobotLifecycle(Robot.Id robotId, String receiverId) {
        super(new DescriptorListBuilder().dependency(theRobotClient, RemoteRobotClient.class).with("robotId", robotId.getRobtIdString()).dependency(theDefReceiver, MessageAsyncReceiver.class).with("messageReceiverId", receiverId).with("messageType", RobotDefinitionResponse.class.getName()).getDescriptors());
        if (robotId == null) {
            throw new NullPointerException();
        }
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = new Properties();
        }
        this.myRegistrationProperties.put("robotId", robotId.getRobtIdString());
        this.myServiceClassNames = new String[]{Robot.class.getName(), RemoteRobot.class.getName()};
    }

    protected RemoteRobot create(Map<String, Object> services) {
        RemoteRobotClient client = (RemoteRobotClient)services.get(theRobotClient);
        MessageAsyncReceiver receiver = (MessageAsyncReceiver)services.get(theDefReceiver);
        try {
            receiver.start();
            return new RemoteRobot(client, (MessageAsyncReceiver<RobotDefinitionResponse>)receiver);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Error starting RemoteRobot messaging components.", ex);
            return null;
        }
    }

    protected void handleChange(String serviceId, Object service, Map<String, Object> dependencies) {
        if (this.myService == null) {
            return;
        }
        if (theRobotClient.equals(serviceId)) {
            this.myService = service != null ? this.create((Map)dependencies) : null;
        } else if (theDefReceiver.equals(serviceId)) {
            ((RemoteRobot)this.myService).setDefinitionReceiver((MessageAsyncReceiver<RobotDefinitionResponse>)((MessageAsyncReceiver)service));
        }
    }

    public Class<Robot> getServiceClass() {
        return Robot.class;
    }
}

