/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.lifecycle;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.osgi.lifecycle.ConfiguredServiceLifecycle;
import org.jflux.api.common.rk.osgi.lifecycle.ConfiguredServiceParams;
import org.jflux.impl.services.rk.lifecycle.utils.DescriptorBuilder;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.jointgroup.JointGroup;
import org.mechio.api.motion.jointgroup.RobotJointGroup;
import org.mechio.api.motion.jointgroup.RobotJointGroupConfig;

public class RobotJointGroupLifecycle<P>
extends ConfiguredServiceLifecycle<JointGroup, RobotJointGroupConfig, P> {
    private static final Logger theLogger = Logger.getLogger(RobotJointGroupLifecycle.class.getName());
    private static final String theRobot = "robot";

    public RobotJointGroupLifecycle(Robot.Id robotId, Class<P> paramClass, String paramId, VersionProperty configFormat) {
        super(new ConfiguredServiceParams(JointGroup.class, RobotJointGroupConfig.class, paramClass, null, null, paramId, RobotJointGroup.VERSION, configFormat));
        this.getDependencyDescriptors().add(new DescriptorBuilder(theRobot, Robot.class).with("robotId", robotId.getRobtIdString()).getDescriptor());
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = new Properties();
        }
        this.myRegistrationProperties.put("robotId", robotId.getRobtIdString());
    }

    protected synchronized JointGroup create(Map<String, Object> dependencies) {
        JointGroup group = (JointGroup)super.create(dependencies);
        if (group == null) {
            return null;
        }
        Robot robot = (Robot)dependencies.get(theRobot);
        this.setRobot(group, robot);
        return group;
    }

    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        super.handleChange(name, dependency, availableDependencies);
        if (this.myService != null && theRobot.equals(name)) {
            this.setRobot((JointGroup)this.myService, (Robot)dependency);
        }
    }

    private void setRobot(JointGroup group, Robot robot) {
        if (group == null) {
            return;
        }
        if (!(group instanceof RobotJointGroup)) {
            theLogger.log(Level.WARNING, "JointGroup is not a RobotJointGroup.  Found {0}.  Unable to set Robot.", group.getClass());
            return;
        }
        ((RobotJointGroup)group).setRobot(robot);
    }
}

