/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.servos;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import org.jflux.api.common.rk.position.NormalizableRange;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.mechio.api.motion.AbstractJoint;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.JointProperty;
import org.mechio.api.motion.servos.Servo;

public class ServoJoint<S extends Servo>
extends AbstractJoint {
    protected S myServo;

    public ServoJoint(Joint.Id jointId, S servo, List<JointProperty> properties) {
        super(jointId);
        if (servo == null) {
            throw new NullPointerException();
        }
        this.myServo = servo;
        this.myServo.addPropertyChangeListener((PropertyChangeListener)this);
        if (properties == null) {
            this.myProperties = new HashMap();
        } else {
            this.myProperties = new HashMap(properties.size());
            for (JointProperty jp : properties) {
                this.myProperties.put(jp.getPropertyName(), jp);
            }
        }
    }

    @Override
    public String getName() {
        return this.myServo.getName();
    }

    @Override
    public NormalizedDouble getDefaultPosition() {
        return this.myServo.getDefaultPosition();
    }

    @Override
    public NormalizableRange<Double> getPositionRange() {
        return this.myServo.getPositionRange();
    }

    @Override
    public void setEnabled(Boolean enabled) {
        Boolean oldVal = this.myServo.getEnabled();
        this.myServo.setEnabled(enabled);
        this.firePropertyChange("enabled", oldVal, enabled);
    }

    @Override
    public Boolean getEnabled() {
        return this.myServo.getEnabled();
    }

    @Override
    public NormalizedDouble getGoalPosition() {
        return this.myServo.getGoalPosition();
    }

    public Servo getServo() {
        return this.myServo;
    }

    protected void setGoalPosition(NormalizedDouble pos) {
        NormalizedDouble oldPos = this.myServo.getGoalPosition();
        this.myServo.setGoalPosition(pos);
        this.firePropertyChange("goalPosition", oldPos, pos);
    }
}

