/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.motion.sync;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jflux.api.common.rk.position.DoubleRange;
import org.jflux.api.common.rk.position.NormalizableRange;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.jflux.api.common.rk.property.PropertyChangeNotifier;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.JointProperty;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.sync.SynchronizedJointConfig;
import org.mechio.api.motion.sync.SynchronizedRobot;

class SynchronizedJoint
extends PropertyChangeNotifier
implements Joint,
PropertyChangeListener {
    private Joint.Id myJointId;
    private String myName;
    private SynchronizedRobot myRobot;
    private NormalizedDouble myDefaultPosition;
    private NormalizedDouble myGoalPosition;
    private Joint myPrimaryJoint;
    private List<Joint> myJoints;
    private boolean myEnabledFlag;
    private NormalizableRange<Double> myRange;
    private static final NormalizableRange<Double> theDefaultRange = new DoubleRange(0.0, 1.0);

    SynchronizedJoint(SynchronizedJointConfig config, SynchronizedRobot robot) {
        this(config.getJointId(), robot, config.getName(), config.getDefaultPosition());
    }

    SynchronizedJoint(Joint.Id id, SynchronizedRobot robot) {
        this(id, robot, "Joint " + id.getLogicalJointNumber(), new NormalizedDouble(0.5));
    }

    SynchronizedJoint(Joint.Id id, SynchronizedRobot robot, String name, NormalizedDouble defPos) {
        if (id == null || robot == null || name == null) {
            throw new NullPointerException();
        }
        this.myRobot = robot;
        this.myJointId = id;
        this.myName = name;
        this.myDefaultPosition = defPos;
        if (this.myDefaultPosition == null) {
            this.myDefaultPosition = new NormalizedDouble(0.5);
        }
        this.myGoalPosition = this.myDefaultPosition;
        this.myEnabledFlag = true;
        this.myJoints = new ArrayList<Joint>();
        this.myRange = new SyncRange();
        this.updateJointList();
    }

    final void updatePrimaryJoint() {
        Robot r;
        if (this.myPrimaryJoint != null) {
            this.myPrimaryJoint.removePropertyChangeListener(this);
        }
        if ((r = this.myRobot.getPrimaryRobot()) == null) {
            this.myPrimaryJoint = null;
            return;
        }
        Robot.JointId jId = new Robot.JointId(r.getRobotId(), this.myJointId);
        Object j = r.getJoint(jId);
        if (this.myJoints.contains(j)) {
            this.myPrimaryJoint = j;
            this.myPrimaryJoint.addPropertyChangeListener(this);
        } else {
            this.myPrimaryJoint = null;
        }
    }

    final void updateJointList() {
        List<Robot> robots = this.myRobot.getRobots();
        this.myJoints.clear();
        for (Robot r : robots) {
            Object j = r.getJoint(new Robot.JointId(r.getRobotId(), this.myJointId));
            if (j == null) continue;
            this.myJoints.add((Joint)j);
        }
        this.updatePrimaryJoint();
    }

    @Override
    public Joint.Id getId() {
        return this.myJointId;
    }

    @Override
    public String getName() {
        if (this.myPrimaryJoint != null) {
            return this.myPrimaryJoint.getName();
        }
        return this.myName;
    }

    @Override
    public NormalizedDouble getDefaultPosition() {
        if (this.myPrimaryJoint != null) {
            return this.myPrimaryJoint.getDefaultPosition();
        }
        return this.myDefaultPosition;
    }

    @Override
    public NormalizedDouble getGoalPosition() {
        if (this.myPrimaryJoint != null) {
            return this.myPrimaryJoint.getGoalPosition();
        }
        return this.myGoalPosition;
    }

    void setGoalPosition(NormalizedDouble pos) {
        this.myGoalPosition = pos;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        for (Joint j : this.myJoints) {
            j.setEnabled(enabled);
        }
        this.myEnabledFlag = enabled;
    }

    @Override
    public Boolean getEnabled() {
        return this.myEnabledFlag;
    }

    @Override
    public <T> JointProperty<T> getProperty(String name, Class<T> propertyType) {
        if (this.myPrimaryJoint == null) {
            return null;
        }
        return this.myPrimaryJoint.getProperty(name, propertyType);
    }

    @Override
    public JointProperty getProperty(String name) {
        if (this.myPrimaryJoint == null) {
            return null;
        }
        return this.myPrimaryJoint.getProperty(name);
    }

    @Override
    public Collection<JointProperty> getProperties() {
        return this.myPrimaryJoint.getProperties();
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        this.firePropertyChange(pce);
    }

    public NormalizableRange getPositionRange() {
        return this.myRange;
    }

    private class SyncRange
    implements NormalizableRange<Double> {
        private SyncRange() {
        }

        private NormalizableRange<Double> getRange() {
            NormalizableRange<Double> range = SynchronizedJoint.this.myPrimaryJoint.getPositionRange();
            if (range == null) {
                return theDefaultRange;
            }
            return range;
        }

        public boolean isValid(Double t) {
            return this.getRange().isValid((Object)t);
        }

        public NormalizedDouble normalizeValue(Double t) {
            return this.getRange().normalizeValue((Object)t);
        }

        public Double denormalizeValue(NormalizedDouble v) {
            return (Double)this.getRange().denormalizeValue(v);
        }

        public Double getMin() {
            return (Double)this.getRange().getMin();
        }

        public Double getMax() {
            return (Double)this.getRange().getMax();
        }
    }
}

