/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.sensor.gpio;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.core.Source;
import org.jflux.api.core.util.DefaultNotifier;
import org.mechio.api.sensor.DeviceReadPeriodEvent;
import org.mechio.api.sensor.GpioConfigEvent;
import org.mechio.api.sensor.gpio.GpioService;
import org.mechio.api.sensor.packet.channel.ChannelBoolEvent;
import org.mechio.api.sensor.packet.stamp.SensorEventHeader;

public class RemoteGpioServiceClient<T extends SensorEventHeader>
extends DefaultNotifier<ChannelBoolEvent<T>>
implements GpioService<T> {
    private static final Logger theLogger = Logger.getLogger(RemoteGpioServiceClient.class.getName());
    private Source<T> myHeaderFactory;
    private Source<Long> myTimestampFactory;
    private Source<? extends ChannelBoolEvent<T>> myBoolEventFactory;
    private Source<? extends GpioConfigEvent<T>> myConfigEventFactory;
    private Notifier<GpioConfigEvent<T>> myDirectionSender;
    private Notifier<ChannelBoolEvent<T>> myOutputValueSender;
    private Notifier<ChannelBoolEvent<T>> myInputValueReceiver;
    private Notifier<DeviceReadPeriodEvent<T>> myReadPeriodSender;
    private Map<Integer, GpioPin> myPins;
    private GpioValueListener myValueListener;
    private int myDirectionSequenceId;
    private int myDirectionFrameId;
    private int myOutputValueSequenceId;
    private int myOutputValueFrameId;
    private int myInputValueSequenceId;
    private int myMask;

    public RemoteGpioServiceClient(Source<T> headerFactory, Source<Long> timestampFactory, Source<? extends ChannelBoolEvent<T>> eventFactory, Source<? extends GpioConfigEvent<T>> configFactory, Notifier<GpioConfigEvent<T>> directionSender, Notifier<DeviceReadPeriodEvent<T>> readPeriodSender, Notifier<ChannelBoolEvent<T>> outputValueSender, Notifier<ChannelBoolEvent<T>> inputValueReceiver, int dirSeqId, int outValSeqId, int inValSeqId, int ... availablePins) {
        this.myHeaderFactory = headerFactory;
        this.myTimestampFactory = timestampFactory;
        this.myBoolEventFactory = eventFactory;
        this.myConfigEventFactory = configFactory;
        this.myDirectionSender = directionSender;
        this.myReadPeriodSender = readPeriodSender;
        this.myOutputValueSender = outputValueSender;
        this.myInputValueReceiver = inputValueReceiver;
        this.myDirectionSequenceId = dirSeqId;
        this.myDirectionFrameId = 0;
        this.myOutputValueSequenceId = outValSeqId;
        this.myOutputValueFrameId = 0;
        this.myInputValueSequenceId = inValSeqId;
        this.myPins = new HashMap<Integer, GpioPin>(availablePins.length);
        for (int i : availablePins) {
            GpioPin pin = new GpioPin(i, false, false);
            this.myPins.put(i, pin);
        }
        this.myValueListener = new GpioValueListener();
        this.myInputValueReceiver.addListener((Listener)this.myValueListener);
        this.myMask = 0;
    }

    @Override
    public Boolean getPinDirection(int channel) {
        GpioPin pin = this.myPins.get(channel);
        if (pin == null) {
            return null;
        }
        return pin.direction;
    }

    @Override
    public void setPinDirection(int channel, boolean direction) {
        GpioPin pin = this.myPins.get(channel);
        if (pin == null || this.myHeaderFactory == null || this.myTimestampFactory == null || this.myBoolEventFactory == null || this.myDirectionSender == null) {
            return;
        }
        SensorEventHeader header = (SensorEventHeader)this.myHeaderFactory.getValue();
        header.setFrameId(this.myDirectionFrameId++);
        header.setSequenceId(this.myDirectionSequenceId);
        header.setTimestamp((Long)this.myTimestampFactory.getValue());
        GpioConfigEvent event = (GpioConfigEvent)this.myConfigEventFactory.getValue();
        this.myMask = direction ? (this.myMask |= 1 << channel) : (this.myMask &= 0 << channel);
        event.setHeader(header);
        event.setInputMask(this.myMask);
        this.myDirectionSender.notifyListeners((Object)event);
        pin.direction = direction;
    }

    @Override
    public Boolean getPinValue(int channel) {
        GpioPin pin = this.myPins.get(channel);
        if (pin == null) {
            return null;
        }
        return pin.value;
    }

    @Override
    public void setPinValue(int channel, boolean val) {
        GpioPin pin = this.myPins.get(channel);
        if (pin == null || this.myHeaderFactory == null || this.myTimestampFactory == null || this.myBoolEventFactory == null || this.myOutputValueSender == null) {
            return;
        }
        if (pin.direction.booleanValue()) {
            theLogger.log(Level.WARNING, "Unable to set pin value for channel {0}, direction must be set OUT.", channel);
            return;
        }
        SensorEventHeader header = (SensorEventHeader)this.myHeaderFactory.getValue();
        header.setFrameId(this.myOutputValueFrameId++);
        header.setSequenceId(this.myOutputValueSequenceId);
        header.setTimestamp((Long)this.myTimestampFactory.getValue());
        ChannelBoolEvent event = (ChannelBoolEvent)this.myBoolEventFactory.getValue();
        event.setHeader(header);
        event.setChannelId(channel);
        event.setBoolValue(val);
        this.myOutputValueSender.notifyListeners((Object)event);
        pin.value = val;
    }

    @Override
    public void setReadPeriod(DeviceReadPeriodEvent<T> readPeriod) {
        if (readPeriod == null) {
            theLogger.log(Level.WARNING, "Null read period.");
            throw new IllegalArgumentException("Read period cannot be null.");
        }
        this.myReadPeriodSender.notifyListeners(readPeriod);
    }

    public void setHeaderFactory(Source<T> headerFactory) {
        this.myHeaderFactory = headerFactory;
    }

    public void setTimestampFactory(Source<Long> timestampFactory) {
        this.myTimestampFactory = timestampFactory;
    }

    public void setEventFactory(Source<ChannelBoolEvent<T>> eventFactory) {
        this.myBoolEventFactory = eventFactory;
    }

    public void setDirectionSender(Notifier<GpioConfigEvent<T>> sender) {
        this.myDirectionSender = sender;
    }

    public void setOutputValueSender(Notifier<ChannelBoolEvent<T>> sender) {
        this.myOutputValueSender = sender;
    }

    public void setInputValueReceiver(Notifier<ChannelBoolEvent<T>> receiver) {
        if (this.myInputValueReceiver != null) {
            this.myInputValueReceiver.removeListener((Listener)this.myValueListener);
        }
        this.myInputValueReceiver = receiver;
        if (this.myInputValueReceiver != null) {
            this.myInputValueReceiver.addListener((Listener)this.myValueListener);
        }
    }

    private void handPinEvent(ChannelBoolEvent<T> t) {
        Boolean val;
        GpioPin pin;
        int chan = t.getChannelId();
        SensorEventHeader header = t.getHeader();
        int seqId = header.getSequenceId();
        if (this.myInputValueSequenceId != seqId) {
            theLogger.log(Level.WARNING, "Unexpected sequenceId for Gpio value: {0}", seqId);
        }
        if ((pin = this.myPins.get(chan)) == null) {
            theLogger.log(Level.WARNING, "Received message for unknown gpio pin {0}", chan);
            return;
        }
        pin.value = val = t.getBoolValue();
        this.notifyListeners(t);
    }

    class GpioValueListener
    implements Listener<ChannelBoolEvent<T>> {
        GpioValueListener() {
        }

        public void handleEvent(ChannelBoolEvent<T> t) {
            RemoteGpioServiceClient.this.handPinEvent(t);
        }
    }

    public class GpioPin {
        public int channel;
        public Boolean direction;
        public Boolean value;

        private GpioPin(int channel, Boolean direction, Boolean value) {
            this.channel = channel;
            this.direction = direction;
            this.value = value;
        }
    }
}

