/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.speech.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.mechio.api.speech.SpeechEvent;
import org.mechio.api.speech.SpeechEventList;
import org.mechio.api.speech.SpeechJob;
import org.mechio.api.speech.SpeechService;
import org.mechio.api.speech.utils.DefaultSpeechJob;

public class SpeechJobManager {
    private static final Logger theLogger = Logger.getLogger(SpeechJobManager.class.getName());
    private SpeechService mySpeechProxy;
    private Map<Long, SpeechJob> mySpeechJobs;
    private Queue<Long> mySpeechJobIds;
    private Long myCurrentSpeechJobId;
    private SpeechEventListener myEventListener;

    public SpeechJobManager(SpeechService speechProxy) {
        if (speechProxy == null) {
            throw new NullPointerException();
        }
        this.mySpeechProxy = speechProxy;
        this.mySpeechJobs = new HashMap<Long, SpeechJob>();
        this.mySpeechJobIds = new LinkedList<Long>();
        this.myCurrentSpeechJobId = null;
        this.myEventListener = new SpeechEventListener();
        this.mySpeechProxy.addSpeechEventListener(this.myEventListener);
    }

    public synchronized SpeechJob createSpeechJob(String text) {
        DefaultSpeechJob job = new DefaultSpeechJob(this, text);
        this.mySpeechJobs.put(job.getSpeechJobId(), job);
        this.mySpeechJobIds.add(job.getSpeechJobId());
        return job;
    }

    void cancelSpeechJob(SpeechJob job) {
        if (this.myCurrentSpeechJobId == null || this.myCurrentSpeechJobId.longValue() == job.getSpeechJobId()) {
            this.mySpeechProxy.cancelSpeech();
        }
    }

    private final class SpeechEventListener
    implements Listener<SpeechEventList<SpeechEvent>> {
        private SpeechEventListener() {
        }

        public synchronized void handleEvent(SpeechEventList<SpeechEvent> t) {
            if (t == null) {
                return;
            }
            for (SpeechEvent event : t.getSpeechEvents()) {
                this.handleSingleEvent(event);
            }
        }

        private void handleSingleEvent(SpeechEvent t) {
            if (t == null) {
                return;
            }
            String eventType = t.getEventType();
            if ("SPEECH_START".equals(eventType)) {
                Long id = (Long)SpeechJobManager.this.mySpeechJobIds.poll();
                if (id == null) {
                    return;
                }
                SpeechJob job = (SpeechJob)SpeechJobManager.this.mySpeechJobs.get(id);
                if (job == null) {
                    theLogger.log(Level.WARNING, "Unable to find SpeechJob with id={0}.  Ignoring SPEECH_START event.", id);
                    return;
                }
                if (3 == job.getStatus()) {
                    SpeechJobManager.this.mySpeechProxy.cancelSpeech();
                    return;
                }
                job.setStatus(1);
                if (SpeechJobManager.this.myCurrentSpeechJobId != null) {
                    this.completeJob(SpeechJobManager.this.myCurrentSpeechJobId);
                }
                SpeechJobManager.this.myCurrentSpeechJobId = id;
            } else if ("SPEECH_END".equals(eventType)) {
                if (SpeechJobManager.this.myCurrentSpeechJobId == null) {
                    return;
                }
                SpeechJob job = (SpeechJob)SpeechJobManager.this.mySpeechJobs.get(SpeechJobManager.this.myCurrentSpeechJobId);
                if (job == null) {
                    theLogger.log(Level.WARNING, "Unable to find SpeechJob with id={0}.  Ignoring SPEECH_END event.", SpeechJobManager.this.myCurrentSpeechJobId);
                    return;
                }
                this.completeJob(SpeechJobManager.this.myCurrentSpeechJobId);
            }
        }

        private void completeJob(long id) {
            SpeechJob job = (SpeechJob)SpeechJobManager.this.mySpeechJobs.get(id);
            if (job == null) {
                return;
            }
            int status = job.getStatus();
            if (status == 2) {
                return;
            }
            if (status == 0 || status == 1) {
                job.setStatus(2);
            }
        }
    }
}

