/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.speech.messaging;

import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.mechio.api.speech.SpeechEvent;
import org.mechio.api.speech.SpeechEventList;
import org.mechio.api.speech.SpeechRequest;
import org.mechio.api.speech.SpeechService;

public class RemoteSpeechServiceHost
implements Listener<SpeechRequest> {
    private SpeechService mySpeechService;
    private Listener<SpeechEventList<SpeechEvent>> mySpeechEventSender;
    private Notifier<SpeechRequest> mySpeechRequestReceiver;
    public static final String PROP_ID = "speechServiceHostId";

    public RemoteSpeechServiceHost() {
        this.mySpeechService = null;
        this.mySpeechEventSender = null;
        this.mySpeechRequestReceiver = null;
    }

    public RemoteSpeechServiceHost(SpeechService service, Listener<SpeechEventList<SpeechEvent>> sender, Notifier<SpeechRequest> receiver) {
        this.mySpeechService = service;
        this.mySpeechEventSender = sender;
        this.mySpeechRequestReceiver = receiver;
        if (this.mySpeechRequestReceiver != null && this.mySpeechService != null) {
            this.mySpeechRequestReceiver.addListener((Listener)this);
        }
        if (this.mySpeechEventSender != null) {
            this.mySpeechService.addSpeechEventListener(sender);
        }
    }

    public void setSpeechService(SpeechService service) {
        if (this.mySpeechEventSender != null && this.mySpeechService != null) {
            this.mySpeechService.removeSpeechEventListener(this.mySpeechEventSender);
        }
        this.mySpeechService = service;
        if (this.mySpeechEventSender != null && this.mySpeechService != null) {
            this.mySpeechService.addSpeechEventListener(this.mySpeechEventSender);
        }
    }

    public void setSpeechRequestReceiver(Notifier<SpeechRequest> receiver) {
        if (this.mySpeechRequestReceiver != null) {
            this.mySpeechRequestReceiver.removeListener((Listener)this);
        }
        this.mySpeechRequestReceiver = receiver;
        if (this.mySpeechRequestReceiver != null) {
            this.mySpeechRequestReceiver.addListener((Listener)this);
        }
    }

    public void setSpeechEventSender(Listener<SpeechEventList<SpeechEvent>> sender) {
        if (this.mySpeechEventSender != null && this.mySpeechService != null) {
            this.mySpeechService.removeSpeechEventListener(this.mySpeechEventSender);
        }
        this.mySpeechEventSender = sender;
        if (this.mySpeechEventSender != null && this.mySpeechService != null) {
            this.mySpeechService.addSpeechEventListener(this.mySpeechEventSender);
        }
    }

    public void handleEvent(SpeechRequest t) {
        if (this.mySpeechService != null) {
            this.mySpeechService.speak(t.getPhrase());
        }
    }
}

