/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.speech.viseme;

import org.mechio.api.speech.SpeechEvent;
import org.mechio.api.speech.viseme.Viseme;
import org.mechio.api.speech.viseme.VisemeEvent;

public class DefaultVisemeEvent
implements VisemeEvent {
    private SpeechEvent mySpeechEvent;
    private long myTimestampMillisecUTC;

    public DefaultVisemeEvent(SpeechEvent speechEvent, long timestampMillisecUTC) {
        if (speechEvent == null) {
            throw new NullPointerException();
        }
        this.mySpeechEvent = speechEvent;
        this.myTimestampMillisecUTC = timestampMillisecUTC;
    }

    public DefaultVisemeEvent(SpeechEvent speechEvent, long timestampMillisecUTC, long timeOffset) {
        if (speechEvent == null) {
            throw new NullPointerException();
        }
        this.mySpeechEvent = speechEvent;
        this.myTimestampMillisecUTC = timestampMillisecUTC + timeOffset;
    }

    @Override
    public long getStream() {
        return this.mySpeechEvent.getStreamNumber();
    }

    @Override
    public Viseme getCurrentViseme() {
        return Viseme.getById(this.mySpeechEvent.getCurrentData());
    }

    @Override
    public Viseme getNextViseme() {
        return Viseme.getById(this.mySpeechEvent.getNextData());
    }

    @Override
    public int getDuration() {
        return this.mySpeechEvent.getDuration();
    }

    @Override
    public long getTimestampMillisecUTC() {
        return this.myTimestampMillisecUTC;
    }
}

