/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.speech.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.utils.EventRepeater;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.core.Listener;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.jflux.api.messaging.rk.services.DefaultServiceClient;
import org.jflux.api.messaging.rk.services.ServiceCommand;
import org.jflux.api.messaging.rk.services.ServiceCommandFactory;
import org.jflux.api.messaging.rk.services.ServiceError;
import org.mechio.api.speech.SpeechEvent;
import org.mechio.api.speech.SpeechEventList;
import org.mechio.api.speech.SpeechJob;
import org.mechio.api.speech.SpeechRequest;
import org.mechio.api.speech.SpeechRequestFactory;
import org.mechio.api.speech.SpeechService;
import org.mechio.api.speech.utils.SpeechEventNotifier;
import org.mechio.api.speech.utils.SpeechJobManager;

public class RemoteSpeechServiceClient<Conf>
extends DefaultServiceClient<Conf>
implements SpeechService {
    private static final Logger theLogger = Logger.getLogger(RemoteSpeechServiceClient.class.getName());
    private String mySpeechServiceId;
    private MessageSender<SpeechRequest> myRequestSender;
    private MessageAsyncReceiver<SpeechEventList<SpeechEvent>> myEventReceiver;
    private SpeechEventNotifier mySpeechEventNotifier;
    private SpeechRequestFactory myRequestFactory;
    private SpeechJobManager myJobManager;
    private EventRepeater<SpeechRequest> myRequestRepeater;

    public RemoteSpeechServiceClient(Class<Conf> configClass, String speechServiceId, String remoteId, MessageSender<ServiceCommand> commandSender, MessageSender<Conf> configSender, MessageAsyncReceiver<ServiceError> errorReceiver, ServiceCommandFactory commandFactory, MessageSender<SpeechRequest> requestSender, MessageAsyncReceiver<SpeechEventList<SpeechEvent>> eventReceiver, SpeechRequestFactory requestFactory) {
        super(speechServiceId, remoteId, commandSender, configSender, errorReceiver, commandFactory);
        if (speechServiceId == null) {
            throw new NullPointerException();
        }
        this.mySpeechServiceId = speechServiceId;
        this.mySpeechEventNotifier = new SpeechEventNotifier();
        this.myRequestSender = requestSender;
        this.myRequestRepeater = new EventRepeater();
        if (this.myRequestSender != null) {
            this.myRequestSender.addListener(this.myRequestRepeater);
        }
        this.myRequestFactory = requestFactory;
        this.myEventReceiver = eventReceiver;
        if (this.myEventReceiver != null) {
            this.myEventReceiver.addListener((Listener)this.mySpeechEventNotifier);
        }
        this.myJobManager = new SpeechJobManager(this);
    }

    @Override
    public String getSpeechServiceId() {
        return this.mySpeechServiceId;
    }

    @Override
    public void start() throws Exception {
        this.start(TimeUtils.now());
    }

    @Override
    public SpeechJob speak(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        if (this.myRequestSender == null || this.myRequestFactory == null) {
            theLogger.warning("Unable to send speech request, Request Sender or Factory is null.");
            return null;
        }
        theLogger.log(Level.INFO, "Speaking: {0}", text);
        SpeechRequest req = this.myRequestFactory.create(this.getClientId(), this.getHostId(), text);
        this.myRequestSender.notifyListeners((Object)req);
        return this.myJobManager.createSpeechJob(text);
    }

    @Override
    public void cancelSpeech() {
        this.send("cancelSpeech");
    }

    @Override
    public void stop() {
        super.stop(TimeUtils.now());
        this.myEventReceiver.stop();
        this.myRequestSender.stop();
    }

    public void setSpeechRequestSender(MessageSender<SpeechRequest> sender) {
        if (this.myRequestSender != null) {
            this.myRequestSender.removeListener(this.myRequestRepeater);
        }
        this.myRequestSender = sender;
        if (this.myRequestSender != null) {
            this.myRequestSender.addListener(this.myRequestRepeater);
        }
    }

    public void setSpeechEventsReceiver(MessageAsyncReceiver<SpeechEventList<SpeechEvent>> receiver) {
        if (this.myEventReceiver != null) {
            this.myEventReceiver.removeListener((Listener)this.mySpeechEventNotifier);
        }
        this.myEventReceiver = receiver;
        if (this.myEventReceiver != null) {
            this.myEventReceiver.addListener((Listener)this.mySpeechEventNotifier);
        }
    }

    public void setSpeechRequestFactory(SpeechRequestFactory factory) {
        this.myRequestFactory = factory;
    }

    @Override
    public void addRequestListener(Listener<SpeechRequest> listener) {
        this.myRequestRepeater.addListener(listener);
    }

    @Override
    public void removeRequestListener(Listener<SpeechRequest> listener) {
        this.myRequestRepeater.removeListener(listener);
    }

    @Override
    public void addSpeechEventListener(Listener<SpeechEventList<SpeechEvent>> listener) {
        this.mySpeechEventNotifier.addSpeechEventListener(listener);
    }

    @Override
    public void removeSpeechEventListener(Listener<SpeechEventList<SpeechEvent>> listener) {
        this.mySpeechEventNotifier.removeSpeechEventListener(listener);
    }
}

