/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.speech.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.jflux.api.messaging.rk.services.ServiceCommand;
import org.jflux.api.messaging.rk.services.ServiceCommandFactory;
import org.jflux.api.messaging.rk.services.ServiceError;
import org.jflux.impl.services.rk.lifecycle.AbstractLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.DescriptorListBuilder;
import org.mechio.api.speech.SpeechConfig;
import org.mechio.api.speech.SpeechEvent;
import org.mechio.api.speech.SpeechEventList;
import org.mechio.api.speech.SpeechRequest;
import org.mechio.api.speech.SpeechRequestFactory;
import org.mechio.api.speech.SpeechService;
import org.mechio.api.speech.messaging.RemoteSpeechServiceClient;

public class RemoteSpeechServiceClientLifecycle
extends AbstractLifecycleProvider<SpeechService, RemoteSpeechServiceClient> {
    private static final String theCommandSender = "commandSender";
    private static final String theConfigSender = "configSender";
    private static final String theErrorReceiver = "errorReceiver";
    private static final String theCommandFactory = "commandFactory";
    private static final String theRequestSender = "requestSender";
    private static final String theEventsReceiver = "eventsReceiver";
    private static final String theRequestFactory = "requestFactory";
    private String myLocalServiceId;
    private String myRemoteServiceId;

    public RemoteSpeechServiceClientLifecycle(String speechServiceId, String remoteId, String commandSenderId, String configSenderId, String errorReceiverId, String requestSenderId, String eventsReceiverId) {
        super(new DescriptorListBuilder().dependency(theCommandSender, MessageSender.class).with("messageSenderId", commandSenderId).with("messageType", ServiceCommand.class.getName()).dependency(theConfigSender, MessageSender.class).with("messageSenderId", configSenderId).with("messageType", SpeechConfig.class.getName()).dependency(theErrorReceiver, MessageAsyncReceiver.class).with("messageReceiverId", errorReceiverId).with("messageType", ServiceError.class.getName()).dependency(theCommandFactory, ServiceCommandFactory.class).dependency(theRequestSender, MessageSender.class).with("messageSenderId", requestSenderId).with("messageType", SpeechRequest.class.getName()).dependency(theEventsReceiver, MessageAsyncReceiver.class).with("messageReceiverId", eventsReceiverId).with("messageType", SpeechEventList.class.getName()).dependency(theRequestFactory, SpeechRequestFactory.class).getDescriptors());
        if (speechServiceId == null || remoteId == null) {
            throw new NullPointerException();
        }
        this.myLocalServiceId = speechServiceId;
        this.myRemoteServiceId = remoteId;
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("speechServiceId", this.myLocalServiceId);
    }

    protected RemoteSpeechServiceClient create(Map<String, Object> services) {
        MessageSender commandSender = (MessageSender)services.get(theCommandSender);
        MessageSender configSender = (MessageSender)services.get(theConfigSender);
        MessageAsyncReceiver errorReceiver = (MessageAsyncReceiver)services.get(theErrorReceiver);
        ServiceCommandFactory commandFactory = (ServiceCommandFactory)services.get(theCommandFactory);
        MessageSender requestSender = (MessageSender)services.get(theRequestSender);
        MessageAsyncReceiver eventsReceiver = (MessageAsyncReceiver)services.get(theEventsReceiver);
        SpeechRequestFactory requestFactory = (SpeechRequestFactory)services.get(theRequestFactory);
        return new RemoteSpeechServiceClient<SpeechConfig>(SpeechConfig.class, this.myLocalServiceId, this.myRemoteServiceId, (MessageSender<ServiceCommand>)commandSender, configSender, (MessageAsyncReceiver<ServiceError>)errorReceiver, commandFactory, (MessageSender<SpeechRequest>)requestSender, (MessageAsyncReceiver<SpeechEventList<SpeechEvent>>)eventsReceiver, requestFactory);
    }

    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (theCommandSender.equals(name)) {
            ((RemoteSpeechServiceClient)this.myService).setCommandSender((MessageSender)dependency);
        } else if (theConfigSender.equals(name)) {
            ((RemoteSpeechServiceClient)this.myService).setConfigSender((MessageSender)dependency);
        } else if (theErrorReceiver.equals(name)) {
            ((RemoteSpeechServiceClient)this.myService).setErrorReceiver((MessageAsyncReceiver)dependency);
        } else if (theCommandFactory.equals(name)) {
            ((RemoteSpeechServiceClient)this.myService).setCommandFactory((ServiceCommandFactory)dependency);
        } else if (theRequestSender.equals(name)) {
            ((RemoteSpeechServiceClient)this.myService).setSpeechRequestSender((MessageSender<SpeechRequest>)((MessageSender)dependency));
        } else if (theEventsReceiver.equals(name)) {
            ((RemoteSpeechServiceClient)this.myService).setSpeechEventsReceiver((MessageAsyncReceiver<SpeechEventList<SpeechEvent>>)((MessageAsyncReceiver)dependency));
        } else if (theRequestFactory.equals(name)) {
            ((RemoteSpeechServiceClient)this.myService).setSpeechRequestFactory((SpeechRequestFactory)dependency);
        }
    }

    public Class<SpeechService> getServiceClass() {
        return SpeechService.class;
    }
}

