/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.speech.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Notifier;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.jflux.impl.services.rk.lifecycle.AbstractLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.DescriptorListBuilder;
import org.mechio.api.speech.SpeechEvent;
import org.mechio.api.speech.SpeechEventList;
import org.mechio.api.speech.SpeechRequest;
import org.mechio.api.speech.SpeechService;
import org.mechio.api.speech.messaging.RemoteSpeechServiceHost;

public class RemoteSpeechServiceHostLifecycle
extends AbstractLifecycleProvider<RemoteSpeechServiceHost, RemoteSpeechServiceHost> {
    private static final String theSpeechService = "speechService";
    private static final String theSpeechRequestReceiver = "speechRequestReceiver";
    private static final String theSpeechEventSender = "speechEventSender";
    private String myLocalServiceId;
    private String myRemoteServiceId;

    public RemoteSpeechServiceHostLifecycle(String speechServiceHostId, String remoteId, String speechServiceId, String speechRequestReceiverId, String speechEventSenderId) {
        super(new DescriptorListBuilder().dependency(theSpeechService, SpeechService.class).with("speechServiceId", speechServiceId).dependency(theSpeechRequestReceiver, MessageAsyncReceiver.class).with("messageReceiverId", speechRequestReceiverId).with("messageType", SpeechRequest.class.getName()).dependency(theSpeechEventSender, MessageSender.class).with("messageSenderId", speechEventSenderId).with("messageType", SpeechEventList.class.getName()).getDescriptors());
        if (speechServiceHostId == null || remoteId == null) {
            throw new NullPointerException();
        }
        this.myLocalServiceId = speechServiceHostId;
        this.myRemoteServiceId = remoteId;
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("speechServiceHostId", this.myLocalServiceId);
    }

    protected RemoteSpeechServiceHost create(Map<String, Object> dependencies) {
        SpeechService service = (SpeechService)dependencies.get(theSpeechService);
        Notifier receiver = (Notifier)dependencies.get(theSpeechRequestReceiver);
        Listener sender = (Listener)dependencies.get(theSpeechEventSender);
        return new RemoteSpeechServiceHost(service, (Listener<SpeechEventList<SpeechEvent>>)sender, (Notifier<SpeechRequest>)receiver);
    }

    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (theSpeechService.equals(name)) {
            ((RemoteSpeechServiceHost)this.myService).setSpeechService((SpeechService)dependency);
        } else if (theSpeechRequestReceiver.equals(name)) {
            ((RemoteSpeechServiceHost)this.myService).setSpeechRequestReceiver((Notifier<SpeechRequest>)((Notifier)dependency));
        } else if (theSpeechEventSender.equals(name)) {
            ((RemoteSpeechServiceHost)this.myService).setSpeechEventSender((Listener<SpeechEventList<SpeechEvent>>)((Listener)dependency));
        }
    }

    protected Class<RemoteSpeechServiceHost> getServiceClass() {
        return RemoteSpeechServiceHost.class;
    }
}

