/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.speech.utils;

import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.core.playable.Playable;
import org.jflux.api.core.util.DefaultNotifier;
import org.mechio.api.speech.SpeechJob;
import org.mechio.api.speech.SpeechRequest;
import org.mechio.api.speech.utils.SpeechJobManager;

public class DefaultSpeechJob
extends DefaultNotifier<Playable.PlayState>
implements SpeechJob {
    public static final int PENDING = 0;
    public static final int RUNNING = 1;
    public static final int COMPLETE = 2;
    public static final int CANCELED = 3;
    private final long myJobId;
    private final SpeechRequest mySpeechRequest;
    private final long myStartTime;
    private int myStatus;
    private SpeechJobManager myManager;
    private static long theNextId = 0L;

    DefaultSpeechJob(SpeechJobManager manager, SpeechRequest speechRequest) {
        if (speechRequest == null) {
            throw new NullPointerException();
        }
        this.myJobId = DefaultSpeechJob.nextId();
        this.myStartTime = TimeUtils.now();
        this.mySpeechRequest = speechRequest;
        this.myStatus = 0;
        this.myManager = manager;
    }

    @Override
    public long getSpeechJobId() {
        return this.myJobId;
    }

    @Override
    public String getSpeechText() {
        return this.mySpeechRequest.getPhrase();
    }

    @Override
    public SpeechRequest getSpeechRequest() {
        return this.mySpeechRequest;
    }

    @Override
    public long getStartTime() {
        return this.myStartTime;
    }

    @Override
    public int getStatus() {
        return this.myStatus;
    }

    @Override
    public void setStatus(int status) {
        this.myStatus = status;
        if (status == 3 && this.myManager != null) {
            this.myManager.cancelSpeechJob(this);
        }
        this.notifyListeners(status == 0 ? Playable.PlayState.PENDING : (status == 1 ? Playable.PlayState.RUNNING : (status == 2 ? Playable.PlayState.COMPLETED : Playable.PlayState.ABORTED)));
    }

    @Override
    public void cancel() {
        this.setStatus(3);
    }

    private static synchronized long nextId() {
        return theNextId++;
    }
}

