/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.speech.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.mechio.api.speech.SpeechEvent;
import org.mechio.api.speech.SpeechEventList;
import org.mechio.api.speech.SpeechJob;
import org.mechio.api.speech.SpeechRequest;
import org.mechio.api.speech.SpeechService;
import org.mechio.api.speech.utils.DefaultSpeechJob;
import org.mechio.api.speech.utils.SpeechJobManager;

public class NaiveSpeechJobManagerImpl
implements SpeechJobManager {
    private static final Logger theLogger = Logger.getLogger(NaiveSpeechJobManagerImpl.class.getName());
    private SpeechService mySpeechProxy;
    private Map<Long, SpeechJob> mySpeechJobs;
    private Queue<Long> mySpeechJobIds;
    private Long myCurrentSpeechJobId;
    private SpeechEventListener myEventListener;

    public NaiveSpeechJobManagerImpl(SpeechService speechProxy) {
        if (speechProxy == null) {
            throw new NullPointerException();
        }
        this.mySpeechProxy = speechProxy;
        this.mySpeechJobs = new HashMap<Long, SpeechJob>();
        this.mySpeechJobIds = new LinkedList<Long>();
        this.myCurrentSpeechJobId = null;
        this.myEventListener = new SpeechEventListener();
        this.mySpeechProxy.addSpeechEventListener(this.myEventListener);
    }

    @Override
    public synchronized SpeechJob createSpeechJob(SpeechRequest req) {
        DefaultSpeechJob job = new DefaultSpeechJob(this, req);
        this.mySpeechJobs.put(job.getSpeechJobId(), job);
        this.mySpeechJobIds.add(job.getSpeechJobId());
        return job;
    }

    @Override
    public void cancelSpeechJob(SpeechJob job) {
        if (this.myCurrentSpeechJobId == null || this.myCurrentSpeechJobId.longValue() == job.getSpeechJobId()) {
            this.mySpeechProxy.cancelSpeech();
        }
    }

    @Override
    public String getRequestIdString() {
        return "";
    }

    private final class SpeechEventListener
    implements Listener<SpeechEventList<SpeechEvent>> {
        private SpeechEventListener() {
        }

        public synchronized void handleEvent(SpeechEventList<SpeechEvent> t) {
            if (t == null) {
                return;
            }
            for (SpeechEvent event : t.getSpeechEvents()) {
                this.handleSingleEvent(event);
            }
        }

        private void handleSingleEvent(SpeechEvent t) {
            if (t == null) {
                return;
            }
            String eventType = t.getEventType();
            if ("SPEECH_START".equals(eventType)) {
                Long id = (Long)NaiveSpeechJobManagerImpl.this.mySpeechJobIds.poll();
                if (id == null) {
                    return;
                }
                SpeechJob job = (SpeechJob)NaiveSpeechJobManagerImpl.this.mySpeechJobs.get(id);
                if (job == null) {
                    theLogger.log(Level.WARNING, "Unable to find SpeechJob with id={0}.  Ignoring SPEECH_START event.", id);
                    return;
                }
                if (3 == job.getStatus()) {
                    NaiveSpeechJobManagerImpl.this.mySpeechProxy.cancelSpeech();
                    return;
                }
                job.setStatus(1);
                if (NaiveSpeechJobManagerImpl.this.myCurrentSpeechJobId != null) {
                    this.completeJob(NaiveSpeechJobManagerImpl.this.myCurrentSpeechJobId);
                }
                NaiveSpeechJobManagerImpl.this.myCurrentSpeechJobId = id;
            } else if ("SPEECH_END".equals(eventType)) {
                if (NaiveSpeechJobManagerImpl.this.myCurrentSpeechJobId == null) {
                    return;
                }
                SpeechJob job = (SpeechJob)NaiveSpeechJobManagerImpl.this.mySpeechJobs.get(NaiveSpeechJobManagerImpl.this.myCurrentSpeechJobId);
                if (job == null) {
                    theLogger.log(Level.WARNING, "Unable to find SpeechJob with id={0}.  Ignoring SPEECH_END event.", NaiveSpeechJobManagerImpl.this.myCurrentSpeechJobId);
                    return;
                }
                this.completeJob(NaiveSpeechJobManagerImpl.this.myCurrentSpeechJobId);
            }
        }

        private void completeJob(long id) {
            SpeechJob job = (SpeechJob)NaiveSpeechJobManagerImpl.this.mySpeechJobs.get(id);
            if (job == null) {
                return;
            }
            int status = job.getStatus();
            if (status == 2) {
                return;
            }
            if (status == 0 || status == 1) {
                job.setStatus(2);
            }
        }
    }
}

