/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.speech.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jflux.api.core.Listener;
import org.mechio.api.speech.SpeechEvent;
import org.mechio.api.speech.SpeechEventList;
import org.mechio.api.speech.SpeechJob;
import org.mechio.api.speech.SpeechRequest;
import org.mechio.api.speech.SpeechService;
import org.mechio.api.speech.utils.DefaultSpeechJob;
import org.mechio.api.speech.utils.SpeechJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechJobManagerImpl
implements SpeechJobManager {
    private static final Logger theLogger = LoggerFactory.getLogger(SpeechJobManagerImpl.class);
    private SpeechService mySpeechProxy;
    private Map<Long, SpeechJob> mySpeechJobs;
    private SpeechJob myActiveSpeechJob;
    private Map<Long, SpeechJob> myPendingJobs;
    private SpeechEventListener myEventListener;

    public SpeechJobManagerImpl(SpeechService speechProxy) {
        if (speechProxy == null) {
            throw new NullPointerException();
        }
        this.mySpeechProxy = speechProxy;
        this.mySpeechJobs = new HashMap<Long, SpeechJob>();
        this.myPendingJobs = new HashMap<Long, SpeechJob>();
        this.myEventListener = new SpeechEventListener();
        this.mySpeechProxy.addSpeechEventListener(this.myEventListener);
    }

    @Override
    public synchronized SpeechJob createSpeechJob(SpeechRequest req) {
        DefaultSpeechJob job = new DefaultSpeechJob(this, req);
        theLogger.debug("Created new speech job with id: {}.", (Object)this.getRequestId(job));
        this.mySpeechJobs.put(this.getRequestId(job), job);
        this.myPendingJobs.put(this.getRequestId(job), job);
        return job;
    }

    @Override
    public void cancelSpeechJob(SpeechJob job) {
        theLogger.info("Attempting to cancel SpeechJob: {}", (Object)this.getRequestId(job));
        if (this.myActiveSpeechJob == job) {
            theLogger.info("SpeechJob {} is active.  Cancelling current speech output.", (Object)this.getRequestId(job));
            this.mySpeechProxy.cancelSpeech();
            this.myActiveSpeechJob = null;
        }
    }

    @Override
    public String getRequestIdString() {
        Integer id = (int)UUID.randomUUID().getMostSignificantBits();
        while (this.mySpeechJobs.containsKey(id)) {
            theLogger.error("PLEASE REPORT THIS ERROR: Collision in speech job id: {}. Discarding and regenerating.", (Object)id);
            id = (int)UUID.randomUUID().getMostSignificantBits();
        }
        theLogger.debug("Generated new speech job id: {}.", (Object)id);
        return id.toString();
    }

    private long getRequestId(SpeechJob job) {
        return this.getRequestIdLong(job.getSpeechRequest().getRequestSourceId());
    }

    private long getRequestIdLong(String reqIdStr) {
        return Long.parseLong(reqIdStr);
    }

    private final class SpeechEventListener
    implements Listener<SpeechEventList<SpeechEvent>> {
        private SpeechEventListener() {
        }

        public synchronized void handleEvent(SpeechEventList<SpeechEvent> t) {
            if (t == null) {
                return;
            }
            for (SpeechEvent event : t.getSpeechEvents()) {
                this.handleSingleEvent(event);
            }
        }

        private void handleSingleEvent(SpeechEvent t) {
            if (t == null) {
                return;
            }
            if (!t.getEventType().equals("VISEME")) {
                theLogger.info("SpeechEvent: {}, id: {}, pos: {}, len: {}, cur: {}, next: {}, str: {}, dur: {}", new Object[]{t.getEventType(), t.getStreamNumber(), t.getTextPosition(), t.getTextLength(), t.getCurrentData(), t.getNextData(), t.getStringData(), t.getDuration()});
            }
            long reqId = t.getStreamNumber();
            if (SpeechJobManagerImpl.this.myActiveSpeechJob != null && SpeechJobManagerImpl.this.getRequestId(SpeechJobManagerImpl.this.myActiveSpeechJob) == reqId) {
                theLogger.debug("SpeechEvent matches active job. Updating status for event type {}.", (Object)t.getEventType());
                this.updateActiveJobStatus(t);
                return;
            }
            if (SpeechJobManagerImpl.this.myActiveSpeechJob != null) {
                theLogger.warn("SpeechEvent does not match active job. Found event id: {}, active job id: {}. This should not happen, SPEECH_END expected for active job before any new events. Assuming SPEECH_END was dropped and marking active job complete.", (Object)t.getStreamNumber(), (Object)SpeechJobManagerImpl.this.getRequestId(SpeechJobManagerImpl.this.myActiveSpeechJob));
                this.completeActiveJob();
            }
            if (!SpeechJobManagerImpl.this.myPendingJobs.containsKey(reqId)) {
                theLogger.debug("Unable to find SpeechJob with id={}. Ignoring SpeechEvent of type={}.", (Object)reqId, (Object)t.getEventType());
                return;
            }
            theLogger.debug("Found SpeechEvent for pending job: {}.  Setting job active.", (Object)reqId);
            SpeechJobManagerImpl.this.myActiveSpeechJob = (SpeechJob)SpeechJobManagerImpl.this.myPendingJobs.remove(reqId);
            if (SpeechJobManagerImpl.this.myActiveSpeechJob.getStatus() == 0) {
                theLogger.debug("Changing status for job: {}, from PENDING to RUNNING.", (Object)reqId);
                SpeechJobManagerImpl.this.myActiveSpeechJob.setStatus(1);
            }
            this.updateActiveJobStatus(t);
        }

        private void updateActiveJobStatus(SpeechEvent t) {
            String eventType = t.getEventType();
            if (3 == SpeechJobManagerImpl.this.myActiveSpeechJob.getStatus() && !"SPEECH_END".equals(eventType)) {
                theLogger.info("Active job: {} has status CANCELED, cancelling speech output.", (Object)SpeechJobManagerImpl.this.getRequestId(SpeechJobManagerImpl.this.myActiveSpeechJob));
                SpeechJobManagerImpl.this.cancelSpeechJob(SpeechJobManagerImpl.this.myActiveSpeechJob);
            } else if ("SPEECH_END".equals(eventType)) {
                theLogger.debug("SPEECH_END found, completing active job: {}.", (Object)SpeechJobManagerImpl.this.getRequestId(SpeechJobManagerImpl.this.myActiveSpeechJob));
                this.completeActiveJob();
            }
        }

        private void completeActiveJob() {
            if (SpeechJobManagerImpl.this.myActiveSpeechJob == null) {
                return;
            }
            if (SpeechJobManagerImpl.this.myActiveSpeechJob.getStatus() != 3 && SpeechJobManagerImpl.this.myActiveSpeechJob.getStatus() != 2) {
                theLogger.debug("Changing status for job: {}, from {} to COMPLETE.", (Object)SpeechJobManagerImpl.this.getRequestId(SpeechJobManagerImpl.this.myActiveSpeechJob), (Object)SpeechJobManagerImpl.this.myActiveSpeechJob.getStatus());
                SpeechJobManagerImpl.this.myActiveSpeechJob.setStatus(2);
            }
            theLogger.debug("Clearing active job: {}.", (Object)SpeechJobManagerImpl.this.getRequestId(SpeechJobManagerImpl.this.myActiveSpeechJob));
            SpeechJobManagerImpl.this.myActiveSpeechJob = null;
        }
    }
}

