/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.speech.viseme;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.core.Listener;
import org.mechio.api.speech.SpeechEvent;
import org.mechio.api.speech.SpeechEventList;
import org.mechio.api.speech.viseme.DefaultVisemeEvent;
import org.mechio.api.speech.viseme.Viseme;
import org.mechio.api.speech.viseme.VisemeEvent;

public class VisemeEventNotifier
implements Listener<SpeechEventList<SpeechEvent>> {
    private static final Logger theLogger = Logger.getLogger(VisemeEventNotifier.class.getName());
    private List<Listener<VisemeEvent>> myListeners = new ArrayList<Listener<VisemeEvent>>();
    private long myRemoteStartTime;
    private long myLocalStartTime;
    private long myTimeOffset;

    public void addListener(Listener<VisemeEvent> listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removeListener(Listener<VisemeEvent> listener) {
        if (this.myListeners.contains(listener)) {
            this.myListeners.remove(listener);
        }
    }

    public void handleEvent(SpeechEventList<SpeechEvent> eventList) {
        if (eventList == null || eventList.getSpeechEvents().isEmpty() || this.myListeners.isEmpty()) {
            return;
        }
        for (SpeechEvent event : eventList.getSpeechEvents()) {
            if (event == null || event.getEventType() == null) {
                return;
            }
            if ("SPEECH_START".equals(event.getEventType())) {
                this.myLocalStartTime = TimeUtils.now();
                this.myRemoteStartTime = TimeUtils.now();
                this.myTimeOffset = this.myLocalStartTime - this.myRemoteStartTime;
                continue;
            }
            if (!"VISEME".equals(event.getEventType())) continue;
            int n = Viseme.values().length;
            Integer cur = event.getCurrentData();
            Integer next = event.getNextData();
            if (cur == null || cur < 0 || cur >= n || next == null || next < 0 || next >= n) {
                theLogger.log(Level.WARNING, "Received invalid viseme data: currentViseme={0}, nextViseme={1}, time={2}", new Object[]{event.getCurrentData(), event.getNextData()});
                return;
            }
            this.handleVisemeEvent(new DefaultVisemeEvent(event, this.myRemoteStartTime, this.myTimeOffset));
        }
    }

    public void handleVisemeEvent(VisemeEvent event) {
        for (Listener<VisemeEvent> l : this.myListeners) {
            l.handleEvent((Object)event);
        }
    }
}

