/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.vision.lifecycle;

import java.util.Map;
import java.util.Properties;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.jflux.api.messaging.rk.services.ServiceCommand;
import org.jflux.api.messaging.rk.services.ServiceCommandFactory;
import org.jflux.api.messaging.rk.services.ServiceError;
import org.jflux.impl.services.rk.lifecycle.AbstractLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.DescriptorListBuilder;
import org.mechio.api.vision.ImageRegionList;
import org.mechio.api.vision.ImageRegionService;
import org.mechio.api.vision.messaging.RemoteImageRegionServiceClient;

public class RemoteImageRegionServiceLifecycle<Conf>
extends AbstractLifecycleProvider<ImageRegionService, RemoteImageRegionServiceClient> {
    private static final String theCommandSender = "commandSender";
    private static final String theConfigSender = "configSender";
    private static final String theErrorReceiver = "errorReceiver";
    private static final String theCommandFactory = "commandFactory";
    private static final String theRegionsReceiver = "imageRegionsReceiver";
    private String myClientServiceId;
    private String myHostServiceId;
    private Class<Conf> myConfigClass;

    public RemoteImageRegionServiceLifecycle(Class<Conf> configClass, String imageServiceId, String remoteId, String commandSenderId, String configSenderId, String errorReceiverId, String requestSenderId, String eventsReceiverId) {
        super(new DescriptorListBuilder().dependency(theCommandSender, MessageSender.class).with("messageSenderId", commandSenderId).with("messageType", ServiceCommand.class.getName()).dependency(theConfigSender, MessageSender.class).with("messageSenderId", configSenderId).with("messageType", configClass.getName()).dependency(theErrorReceiver, MessageAsyncReceiver.class).with("messageReceiverId", errorReceiverId).with("messageType", ServiceError.class.getName()).dependency(theRegionsReceiver, MessageAsyncReceiver.class).with("messageReceiverId", eventsReceiverId).with("messageType", ImageRegionList.class.getName()).dependency(theCommandFactory, ServiceCommandFactory.class).getDescriptors());
        if (imageServiceId == null || remoteId == null) {
            throw new NullPointerException();
        }
        this.myClientServiceId = imageServiceId;
        this.myHostServiceId = remoteId;
        this.myRegistrationProperties = new Properties();
        this.myRegistrationProperties.put("imageServiceId", this.myClientServiceId);
    }

    protected RemoteImageRegionServiceClient create(Map<String, Object> services) {
        MessageSender commandSender = (MessageSender)services.get(theCommandSender);
        MessageSender configSender = (MessageSender)services.get(theConfigSender);
        MessageAsyncReceiver errorReceiver = (MessageAsyncReceiver)services.get(theErrorReceiver);
        ServiceCommandFactory commandFactory = (ServiceCommandFactory)services.get(theCommandFactory);
        MessageAsyncReceiver imageReceiver = (MessageAsyncReceiver)services.get(theRegionsReceiver);
        return new RemoteImageRegionServiceClient<Conf>(this.myConfigClass, this.myClientServiceId, this.myHostServiceId, (MessageSender<ServiceCommand>)commandSender, configSender, (MessageAsyncReceiver<ServiceError>)errorReceiver, commandFactory, (MessageAsyncReceiver<ImageRegionList>)imageReceiver);
    }

    protected void handleChange(String name, Object dependency, Map<String, Object> availableDependencies) {
        if (this.myService == null) {
            return;
        }
        if (theCommandSender.equals(name)) {
            ((RemoteImageRegionServiceClient)this.myService).setCommandSender((MessageSender)dependency);
        } else if (theConfigSender.equals(name)) {
            ((RemoteImageRegionServiceClient)this.myService).setConfigSender((MessageSender)dependency);
        } else if (theErrorReceiver.equals(name)) {
            ((RemoteImageRegionServiceClient)this.myService).setErrorReceiver((MessageAsyncReceiver)dependency);
        } else if (theCommandFactory.equals(name)) {
            ((RemoteImageRegionServiceClient)this.myService).setCommandFactory((ServiceCommandFactory)dependency);
        } else if (theRegionsReceiver.equals(name)) {
            ((RemoteImageRegionServiceClient)this.myService).setImageRegionsReceiver((MessageAsyncReceiver<ImageRegionList>)((MessageAsyncReceiver)dependency));
        }
    }

    public Class<ImageRegionService> getServiceClass() {
        return ImageRegionService.class;
    }
}

