/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.api.vision.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.playable.PlayState;
import org.jflux.api.common.rk.utils.EventRepeater;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.core.Listener;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.jflux.api.messaging.rk.services.DefaultServiceClient;
import org.jflux.api.messaging.rk.services.ServiceCommand;
import org.jflux.api.messaging.rk.services.ServiceCommandFactory;
import org.jflux.api.messaging.rk.services.ServiceError;
import org.mechio.api.vision.ImageRegionList;
import org.mechio.api.vision.ImageRegionService;
import org.mechio.api.vision.messaging.RemoteImageServiceClient;

public class RemoteImageRegionServiceClient<Conf>
extends DefaultServiceClient<Conf>
implements ImageRegionService {
    private static final Logger theLogger = Logger.getLogger(RemoteImageServiceClient.class.getName());
    private String myImageRegionsServiceId;
    private MessageAsyncReceiver<ImageRegionList> myRegionsReceiver;
    private EventRepeater<ImageRegionList> myRegionsEventRepeater;

    public RemoteImageRegionServiceClient(Class<Conf> configClass, String imageRegionsServiceId, String remoteId, MessageSender<ServiceCommand> commandSender, MessageSender<Conf> configSender, MessageAsyncReceiver<ServiceError> errorReceiver, ServiceCommandFactory commandFactory, MessageAsyncReceiver<ImageRegionList> regionsReceiver) {
        super(imageRegionsServiceId, remoteId, commandSender, configSender, errorReceiver, commandFactory);
        if (imageRegionsServiceId == null) {
            throw new NullPointerException();
        }
        this.myImageRegionsServiceId = imageRegionsServiceId;
        this.myRegionsReceiver = regionsReceiver;
        this.myRegionsEventRepeater = new EventRepeater();
    }

    @Override
    public String getImageServiceId() {
        return this.myImageRegionsServiceId;
    }

    @Override
    public void start() {
        super.start(TimeUtils.now());
    }

    @Override
    public void stop() {
        super.stop(TimeUtils.now());
    }

    public boolean onComplete(long time) {
        return this.playStateChange(super.onComplete(time), PlayState.COMPLETED);
    }

    public boolean onPause(long time) {
        return this.playStateChange(super.onPause(time), PlayState.PAUSED);
    }

    public boolean onResume(long time) {
        return this.playStateChange(super.onResume(time), PlayState.RUNNING);
    }

    public boolean onStart(long time) {
        return this.playStateChange(super.onStart(time), PlayState.RUNNING);
    }

    public boolean onStop(long time) {
        return this.playStateChange(super.onStop(time), PlayState.STOPPED);
    }

    private boolean playStateChange(boolean attempt, PlayState state) {
        if (!attempt) {
            return false;
        }
        if (this.myRegionsReceiver == null) {
            theLogger.log(Level.INFO, "PlayState changed to {0}, but ImageReceiver is null.", state);
            return true;
        }
        if (state == PlayState.RUNNING) {
            theLogger.log(Level.INFO, "PlayState changed to {0}, adding repeater to ImageReceiver.", state);
            this.myRegionsReceiver.addListener(this.myRegionsEventRepeater);
        } else {
            theLogger.log(Level.INFO, "PlayState changed to {0}, removing repeater from ImageReceiver.", state);
            this.myRegionsReceiver.removeListener(this.myRegionsEventRepeater);
        }
        return true;
    }

    public void setImageRegionsReceiver(MessageAsyncReceiver<ImageRegionList> receiver) {
        if (this.myRegionsReceiver != null) {
            this.myRegionsReceiver.removeListener(this.myRegionsEventRepeater);
        }
        this.myRegionsReceiver = receiver;
        if (this.myRegionsReceiver != null && PlayState.RUNNING == this.getPlayState()) {
            this.myRegionsReceiver.addListener(this.myRegionsEventRepeater);
        }
    }

    @Override
    public void addImageRegionsListener(Listener<ImageRegionList> listener) {
        this.myRegionsEventRepeater.addListener(listener);
    }

    @Override
    public void removeImageRegionsListener(Listener<ImageRegionList> listener) {
        this.myRegionsEventRepeater.removeListener(listener);
    }
}

