/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.client.basic;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.mechio.api.animation.Animation;
import org.mechio.api.animation.messaging.RemoteAnimationPlayerClient;
import org.mechio.api.motion.messaging.RemoteRobot;
import org.mechio.api.motion.messaging.RemoteRobotClient;
import org.mechio.api.motion.protocol.RobotDefinitionResponse;
import org.mechio.api.sensor.gpio.GpioService;
import org.mechio.api.sensor.gpio.RemoteGpioServiceClient;
import org.mechio.api.sensor.imu.RemoteAccelerometerServiceClient;
import org.mechio.api.sensor.imu.RemoteCompassServiceClient;
import org.mechio.api.sensor.imu.RemoteGyroscopeServiceClient;
import org.mechio.api.speech.SpeechConfig;
import org.mechio.api.speech.messaging.RemoteSpeechServiceClient;
import org.mechio.api.vision.config.CameraServiceConfig;
import org.mechio.api.vision.config.FaceDetectServiceConfig;
import org.mechio.api.vision.messaging.RemoteImageRegionServiceClient;
import org.mechio.api.vision.messaging.RemoteImageServiceClient;
import org.mechio.client.basic.ConnectionContext;
import org.mechio.client.basic.MioAccelerometerConnector;
import org.mechio.client.basic.MioAnimationConnector;
import org.mechio.client.basic.MioCameraConnector;
import org.mechio.client.basic.MioCompassConnector;
import org.mechio.client.basic.MioGyroscopeConnector;
import org.mechio.client.basic.MioImageRegionConnector;
import org.mechio.client.basic.MioRobotConnector;
import org.mechio.client.basic.MioSensorConnector;
import org.mechio.client.basic.MioSpeechConnector;
import org.mechio.client.basic.UserSettings;
import org.mechio.impl.animation.xml.AnimationXMLReader;
import org.mechio.impl.animation.xml.XPP3AnimationXMLWriter;
import org.mechio.impl.sensor.HeaderRecord;

public final class MechIO {
    private static final Logger theLogger = Logger.getLogger(MechIO.class.getName());
    private static final Map<String, ConnectionContext> theConnectionMap = new HashMap<String, ConnectionContext>();
    private static final String theRobotContext = "robotContext";
    private static final String theSpeechContext = "speechContext";
    private static final String theAnimationContext = "animContext";
    private static final String theSensorContext = "sensorContext";
    private static final String theCameraContext = "cameraContext";
    private static final String theImageRegionContext = "imageRegionContext";

    public static RemoteRobot connectRobot() {
        try {
            ConnectionContext context = MechIO.getContext(theRobotContext);
            context.addConnection(MioRobotConnector.getConnector(), UserSettings.getRobotAddress());
            RemoteRobotClient robotClient = MioRobotConnector.getConnector().buildRemoteClient();
            context.start();
            MessageAsyncReceiver<RobotDefinitionResponse> receiver = MioRobotConnector.getConnector().getDefReceiver();
            return new RemoteRobot(robotClient, receiver);
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Remote Robot.", ex);
            return null;
        }
    }

    public static RemoteAnimationPlayerClient connectAnimationPlayer() {
        try {
            ConnectionContext context = MechIO.getContext(theAnimationContext);
            context.addConnection(MioAnimationConnector.getConnector(), UserSettings.getAnimationAddress());
            context.start();
            return MioAnimationConnector.getConnector().buildRemoteClient();
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Remote Animation Player.", ex);
            return null;
        }
    }

    public static RemoteSpeechServiceClient connectSpeechService() {
        try {
            ConnectionContext context = MechIO.getContext(theSpeechContext);
            context.addConnection(MioSpeechConnector.getConnector(), UserSettings.getSpeechAddress());
            RemoteSpeechServiceClient<SpeechConfig> speechClient = MioSpeechConnector.getConnector().buildRemoteClient();
            context.start();
            speechClient.start();
            return speechClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Remote Speech Service.", ex);
            return null;
        }
    }

    public static RemoteGpioServiceClient<HeaderRecord> connectSensors() {
        try {
            ConnectionContext context = MechIO.getContext(theSensorContext);
            context.addConnection(MioSensorConnector.getConnector(), UserSettings.getSensorAddress());
            RemoteGpioServiceClient gpioClient = MioSensorConnector.getConnector().buildRemoteClient();
            context.start();
            MioSensorConnector.initializeGpioClient((GpioService)gpioClient);
            return gpioClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Remote Sensors.", ex);
            return null;
        }
    }

    public static RemoteAccelerometerServiceClient<HeaderRecord> connectAccelerometer() {
        try {
            ConnectionContext context = MechIO.getContext(theSensorContext);
            context.addConnection(MioAccelerometerConnector.getConnector(), UserSettings.getAccelerometerAddress());
            RemoteAccelerometerServiceClient accelClient = MioAccelerometerConnector.getConnector().buildRemoteClient();
            context.start();
            return accelClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Remote Accelerometer.", ex);
            return null;
        }
    }

    public static RemoteGyroscopeServiceClient<HeaderRecord> connectGyroscope() {
        try {
            ConnectionContext context = MechIO.getContext(theSensorContext);
            context.addConnection(MioGyroscopeConnector.getConnector(), UserSettings.getGyroscopeAddress());
            RemoteGyroscopeServiceClient gyroClient = MioGyroscopeConnector.getConnector().buildRemoteClient();
            context.start();
            return gyroClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Remote Gyroscope.", ex);
            return null;
        }
    }

    public static RemoteCompassServiceClient<HeaderRecord> connectCompass() {
        try {
            ConnectionContext context = MechIO.getContext(theSensorContext);
            context.addConnection(MioCompassConnector.getConnector(), UserSettings.getCompassAddress());
            RemoteCompassServiceClient compassClient = MioCompassConnector.getConnector().buildRemoteClient();
            context.start();
            return compassClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Remote Compass.", ex);
            return null;
        }
    }

    public static RemoteImageServiceClient<CameraServiceConfig> connectCameraService() {
        try {
            ConnectionContext context = MechIO.getContext(theCameraContext);
            context.addConnection(MioCameraConnector.getConnector(), UserSettings.getCameraAddress());
            RemoteImageServiceClient<CameraServiceConfig> cameraClient = MioCameraConnector.getConnector().buildRemoteClient();
            context.start();
            cameraClient.start();
            return cameraClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Remote Camera.", ex);
            return null;
        }
    }

    public static RemoteImageRegionServiceClient<FaceDetectServiceConfig> connectImageRegionService() {
        try {
            ConnectionContext context = MechIO.getContext(theImageRegionContext);
            context.addConnection(MioImageRegionConnector.getConnector(), UserSettings.getImageRegionAddress());
            RemoteImageRegionServiceClient<FaceDetectServiceConfig> imageRegionClient = MioImageRegionConnector.getConnector().buildRemoteClient();
            context.start();
            imageRegionClient.start();
            return imageRegionClient;
        }
        catch (Exception ex) {
            theLogger.log(Level.SEVERE, "Unable to connect to Remote image region service.", ex);
            return null;
        }
    }

    private static synchronized ConnectionContext getContext(String key) {
        ConnectionContext cc = theConnectionMap.get(key);
        if (cc == null) {
            cc = new ConnectionContext();
            theConnectionMap.put(key, cc);
        }
        return cc;
    }

    public static Animation loadAnimation(String filepath) {
        try {
            return new AnimationXMLReader().readAnimation(filepath);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Unable to load animation.", ex);
            return null;
        }
    }

    public static boolean saveAnimation(String filepath, Animation anim) {
        try {
            new XPP3AnimationXMLWriter().writeAnimation(filepath, anim, null, null);
            return true;
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Unable to load animation.", ex);
            return false;
        }
    }

    public static long currentTime() {
        return TimeUtils.now();
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            theLogger.log(Level.WARNING, "Sleep interrupted.", ex);
        }
    }

    public static void disconnect() {
        for (ConnectionContext cc : theConnectionMap.values()) {
            cc.stop();
        }
        theConnectionMap.clear();
        MioRobotConnector.clearConnector();
        MioAnimationConnector.theMioAnimationConnector = null;
        MioSpeechConnector.theMioSpeechConnector = null;
    }
}

