/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.messaging.rk.MessageSender;
import org.mechio.api.animation.messaging.RemoteAnimationPlayerClient;
import org.mechio.api.animation.protocol.AnimationEvent;
import org.mechio.client.basic.ConnectionContext;
import org.mechio.impl.animation.messaging.PortableAnimationEvent;

final class MioAnimationConnector
extends ConnectionContext.MioServiceConnector {
    static final String ANIMATION_SENDER = "animationSender";
    private String myAnimDest = "animationRequest";
    static MioAnimationConnector theMioAnimationConnector;

    MioAnimationConnector() {
    }

    static synchronized MioAnimationConnector getConnector() {
        if (theMioAnimationConnector == null) {
            theMioAnimationConnector = new MioAnimationConnector();
        }
        return theMioAnimationConnector;
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        Destination anim = ConnectionContext.getTopic(this.myAnimDest);
        this.myConnectionContext.addSender(ANIMATION_SENDER, session, anim, new PortableAnimationEvent.MessageRecordAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteAnimationPlayerClient buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        MessageSender animSender = this.myConnectionContext.getSender(ANIMATION_SENDER);
        RemoteAnimationPlayerClient client = new RemoteAnimationPlayerClient(null, "animationPlayer", "remoteAnimationPlayerId");
        client.setAnimationEventFactory((AnimationEvent.AnimationEventFactory)new PortableAnimationEvent.Factory());
        client.setAnimationEventSender(animSender);
        return client;
    }
}

