/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.core.util.EmptyAdapter;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.jflux.api.messaging.rk.services.ServiceCommandFactory;
import org.jflux.impl.messaging.rk.ServiceErrorRecord;
import org.jflux.impl.messaging.rk.services.PortableServiceCommand;
import org.mechio.api.vision.config.CameraServiceConfig;
import org.mechio.api.vision.messaging.RemoteImageServiceClient;
import org.mechio.client.basic.ConnectionContext;
import org.mechio.client.basic.UserSettings;
import org.mechio.impl.vision.ImageRecord;

final class MioCameraConnector
extends ConnectionContext.MioServiceConnector {
    static final String CMD_SENDER = "cmCommandSender";
    static final String CONFIG_SENDER = "cmConfigSender";
    static final String ERROR_RECEIVER = "cmErrorReceiver";
    static final String EVENT_RECEIVER = "cmEventReceiver";
    static MioCameraConnector theMioCameraConnector;
    private String myCommandDest = "camera0Command";
    private String myConfigDest = "camera0Command";
    private String myErrorDest = "camera0Error";
    private String myEventDest = "camera0Event";

    MioCameraConnector() {
    }

    static synchronized MioCameraConnector getConnector() {
        if (theMioCameraConnector == null) {
            theMioCameraConnector = new MioCameraConnector();
        }
        return theMioCameraConnector;
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        this.readCameraId();
        Destination cmdDest = ConnectionContext.getQueue(this.myCommandDest);
        Destination confDest = ConnectionContext.getQueue(this.myConfigDest);
        Destination errDest = ConnectionContext.getTopic(this.myErrorDest);
        Destination evtDest = ConnectionContext.getTopic(this.myEventDest);
        this.myConnectionContext.addSender(CMD_SENDER, session, cmdDest, new EmptyAdapter());
        this.myConnectionContext.addSender(CONFIG_SENDER, session, confDest, new EmptyAdapter());
        this.myConnectionContext.addAsyncReceiver(ERROR_RECEIVER, session, errDest, ServiceErrorRecord.class, ServiceErrorRecord.SCHEMA$, new EmptyAdapter());
        this.myConnectionContext.addAsyncReceiver(EVENT_RECEIVER, session, evtDest, ImageRecord.class, ImageRecord.SCHEMA$, new EmptyAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteImageServiceClient<CameraServiceConfig> buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        MessageSender cmdSender = this.myConnectionContext.getSender(CMD_SENDER);
        MessageSender confSender = this.myConnectionContext.getSender(CONFIG_SENDER);
        MessageAsyncReceiver errReceiver = this.myConnectionContext.getAsyncReceiver(ERROR_RECEIVER);
        MessageAsyncReceiver evtReceiver = this.myConnectionContext.getAsyncReceiver(EVENT_RECEIVER);
        RemoteImageServiceClient client = new RemoteImageServiceClient(CameraServiceConfig.class, "imageServiceId", "remoteImageServiceId", cmdSender, confSender, errReceiver, (ServiceCommandFactory)new PortableServiceCommand.Factory(), evtReceiver);
        return client;
    }

    private synchronized void readCameraId() {
        String cameraId = UserSettings.getCameraId();
        if (cameraId.equals("0")) {
            this.myCommandDest = this.myCommandDest.replace("1", cameraId);
            this.myConfigDest = this.myConfigDest.replace("1", cameraId);
            this.myErrorDest = this.myErrorDest.replace("1", cameraId);
            this.myEventDest = this.myEventDest.replace("1", cameraId);
        } else if (cameraId.equals("1")) {
            this.myCommandDest = this.myCommandDest.replace("0", cameraId);
            this.myConfigDest = this.myConfigDest.replace("0", cameraId);
            this.myErrorDest = this.myErrorDest.replace("0", cameraId);
            this.myEventDest = this.myEventDest.replace("0", cameraId);
        }
    }
}

