/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.core.util.EmptyAdapter;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.mechio.api.sensor.imu.RemoteCompassServiceClient;
import org.mechio.client.basic.ConnectionContext;
import org.mechio.impl.sensor.FilteredVector3Record;

final class MioCompassConnector
extends ConnectionContext.MioServiceConnector {
    static final String COMPASS_VALUE_RECEIVER = "compassValueReceiver";
    static final String COMPASS_CONFIG_SENDER = "compassConfigSender";
    static final String COMPASS_READ_PERIOD_SENDER = "compassReadPeriodSender";
    private static MioCompassConnector theMioCompassConnector;
    private String theCompassInputDest = "compassEvent";
    private String theCompassConfigDest = "compassConfig";
    private String theCompassReadDest = "compassRead";

    MioCompassConnector() {
    }

    static synchronized MioCompassConnector getConnector() {
        if (theMioCompassConnector == null) {
            theMioCompassConnector = new MioCompassConnector();
        }
        return theMioCompassConnector;
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        Destination compassValReceiver = ConnectionContext.getTopic(this.theCompassInputDest);
        this.myConnectionContext.addAsyncReceiver(COMPASS_VALUE_RECEIVER, session, compassValReceiver, FilteredVector3Record.class, FilteredVector3Record.SCHEMA$, new EmptyAdapter());
        Destination compassCfgSender = ConnectionContext.getTopic(this.theCompassConfigDest);
        this.myConnectionContext.addSender(COMPASS_CONFIG_SENDER, session, compassCfgSender, new EmptyAdapter());
        Destination compassPerSender = ConnectionContext.getTopic(this.theCompassReadDest);
        this.myConnectionContext.addSender(COMPASS_READ_PERIOD_SENDER, session, compassPerSender, new EmptyAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteCompassServiceClient buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        MessageAsyncReceiver compassValReceiver = this.myConnectionContext.getAsyncReceiver(COMPASS_VALUE_RECEIVER);
        MessageSender compassCfgSender = this.myConnectionContext.getSender(COMPASS_CONFIG_SENDER);
        MessageSender compassPerSender = this.myConnectionContext.getSender(COMPASS_READ_PERIOD_SENDER);
        RemoteCompassServiceClient client = new RemoteCompassServiceClient(compassCfgSender, compassPerSender, compassValReceiver);
        return client;
    }
}

