/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.core.Source;
import org.jflux.api.core.util.DefaultTimestampSource;
import org.jflux.api.core.util.EmptyAdapter;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.mechio.api.sensor.gpio.GpioService;
import org.mechio.api.sensor.gpio.RemoteGpioServiceClient;
import org.mechio.client.basic.ConnectionContext;
import org.mechio.client.basic.RobotSensors;
import org.mechio.impl.sensor.ChannelBoolRecord;
import org.mechio.impl.sensor.GpioConfigRecord;
import org.mechio.impl.sensor.HeaderRecord;

final class MioSensorConnector
extends ConnectionContext.MioServiceConnector {
    static final String GPIO_VALUE_RECEIVER = "gpioValueReceiver";
    static final String GPIO_DIRECTION_SENDER = "gpioDirectionSender";
    static final String GPIO_READ_PERIOD_SENDER = "gpioReadPeriodSender";
    static final String GPIO_VALUE_SENDER = "gpioValueSender";
    private static MioSensorConnector theMioSensorConnector;
    private String theGpioInputDest = "gpioEvent";
    private String theGpioDirectionDest = "gpioConfig";
    private String theGpioOutputDest = "gpioWrite";
    private String theGpioReadDest = "gpioRead";

    MioSensorConnector() {
    }

    static synchronized MioSensorConnector getConnector() {
        if (theMioSensorConnector == null) {
            theMioSensorConnector = new MioSensorConnector();
        }
        return theMioSensorConnector;
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        Destination gpioValReceiver = ConnectionContext.getTopic(this.theGpioInputDest);
        this.myConnectionContext.addAsyncReceiver(GPIO_VALUE_RECEIVER, session, gpioValReceiver, ChannelBoolRecord.class, ChannelBoolRecord.SCHEMA$, new EmptyAdapter());
        Destination gpioDirSender = ConnectionContext.getTopic(this.theGpioDirectionDest);
        this.myConnectionContext.addSender(GPIO_DIRECTION_SENDER, session, gpioDirSender, new EmptyAdapter());
        Destination gpioPerSender = ConnectionContext.getTopic(this.theGpioReadDest);
        this.myConnectionContext.addSender(GPIO_READ_PERIOD_SENDER, session, gpioPerSender, new EmptyAdapter());
        Destination gpioValSender = ConnectionContext.getTopic(this.theGpioOutputDest);
        this.myConnectionContext.addSender(GPIO_VALUE_SENDER, session, gpioValSender, new EmptyAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteGpioServiceClient buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        MessageAsyncReceiver gpioValReceiver = this.myConnectionContext.getAsyncReceiver(GPIO_VALUE_RECEIVER);
        MessageSender gpioDirSender = this.myConnectionContext.getSender(GPIO_DIRECTION_SENDER);
        MessageSender gpioPerSender = this.myConnectionContext.getSender(GPIO_READ_PERIOD_SENDER);
        MessageSender gpioValSender = this.myConnectionContext.getSender(GPIO_VALUE_SENDER);
        HeaderRecord.Builder headerFact = HeaderRecord.newBuilder();
        headerFact.setFrameId(0);
        headerFact.setSequenceId(0);
        headerFact.setTimestamp(0L);
        HeaderRecord emptyHeader = headerFact.build();
        ChannelBoolRecord.Builder eventFact = ChannelBoolRecord.newBuilder();
        eventFact.setHeader(emptyHeader);
        eventFact.setChannelId(0);
        eventFact.setBoolValue(false);
        GpioConfigRecord.Builder configFact = GpioConfigRecord.newBuilder();
        configFact.setHeader(emptyHeader);
        configFact.setInputMask(0);
        RemoteGpioServiceClient client = new RemoteGpioServiceClient((Source)headerFact, (Source)new DefaultTimestampSource(), (Source)eventFact, (Source)configFact, gpioDirSender, gpioPerSender, gpioValSender, gpioValReceiver, 0, 0, 0, new int[]{0, 1, 2, 3, 4, 5, 8, 9, 10, 11});
        return client;
    }

    static void initializeGpioClient(GpioService client) {
        client.setPinDirection(8, false);
        client.setPinValue(8, true);
        client.setPinDirection(10, false);
        client.setPinValue(10, true);
        for (int i : RobotSensors.ALL_GPIO_PINS) {
            client.setPinDirection(i, true);
        }
    }
}

