/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.core.util.EmptyAdapter;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.jflux.api.messaging.rk.services.ServiceCommandFactory;
import org.jflux.impl.messaging.rk.ServiceErrorRecord;
import org.jflux.impl.messaging.rk.services.PortableServiceCommand;
import org.mechio.api.speech.SpeechConfig;
import org.mechio.api.speech.SpeechRequestFactory;
import org.mechio.api.speech.messaging.RemoteSpeechServiceClient;
import org.mechio.client.basic.ConnectionContext;
import org.mechio.impl.speech.PortableSpeechRequest;
import org.mechio.impl.speech.SpeechEventListRecord;

final class MioSpeechConnector
extends ConnectionContext.MioServiceConnector {
    static final String CMD_SENDER = "spCommandSender";
    static final String CONFIG_SENDER = "spConfigSender";
    static final String ERROR_RECEIVER = "spErrorReceiver";
    static final String SPEECH_SENDER = "spRequestSender";
    static final String EVENT_RECEIVER = "spEventReceiver";
    static MioSpeechConnector theMioSpeechConnector;
    private String myCommandDest = "speechCommand";
    private String myConfigDest = "speechCommand";
    private String myErrorDest = "speechError";
    private String myRequestDest = "speechRequest";
    private String myEventDest = "speechEvent";

    MioSpeechConnector() {
    }

    static synchronized MioSpeechConnector getConnector() {
        if (theMioSpeechConnector == null) {
            theMioSpeechConnector = new MioSpeechConnector();
        }
        return theMioSpeechConnector;
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        Destination cmdDest = ConnectionContext.getQueue(this.myCommandDest);
        Destination confDest = ConnectionContext.getQueue(this.myConfigDest);
        Destination errDest = ConnectionContext.getTopic(this.myErrorDest);
        Destination reqDest = ConnectionContext.getQueue(this.myRequestDest);
        Destination evtDest = ConnectionContext.getTopic(this.myEventDest);
        this.myConnectionContext.addSender(CMD_SENDER, session, cmdDest, new EmptyAdapter());
        this.myConnectionContext.addSender(CONFIG_SENDER, session, confDest, new EmptyAdapter());
        this.myConnectionContext.addAsyncReceiver(ERROR_RECEIVER, session, errDest, ServiceErrorRecord.class, ServiceErrorRecord.SCHEMA$, new EmptyAdapter());
        this.myConnectionContext.addSender(SPEECH_SENDER, session, reqDest, new EmptyAdapter());
        this.myConnectionContext.addAsyncReceiver(EVENT_RECEIVER, session, evtDest, SpeechEventListRecord.class, SpeechEventListRecord.SCHEMA$, new EmptyAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteSpeechServiceClient<SpeechConfig> buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        MessageSender cmdSender = this.myConnectionContext.getSender(CMD_SENDER);
        MessageSender confSender = this.myConnectionContext.getSender(CONFIG_SENDER);
        MessageAsyncReceiver errReceiver = this.myConnectionContext.getAsyncReceiver(ERROR_RECEIVER);
        MessageSender reqSender = this.myConnectionContext.getSender(SPEECH_SENDER);
        MessageAsyncReceiver evtReceiver = this.myConnectionContext.getAsyncReceiver(EVENT_RECEIVER);
        RemoteSpeechServiceClient client = new RemoteSpeechServiceClient(SpeechConfig.class, "speechServiceId", "remoteSpeechServiceId", cmdSender, confSender, errReceiver, (ServiceCommandFactory)new PortableServiceCommand.Factory(), reqSender, evtReceiver, (SpeechRequestFactory)new PortableSpeechRequest.Factory());
        return client;
    }
}

