/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.client.basic;

import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageBlockingReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.mechio.api.motion.Robot;
import org.mechio.api.motion.messaging.RemoteRobotClient;
import org.mechio.api.motion.messaging.RobotRequestFactory;
import org.mechio.api.motion.protocol.MotionFrameEvent;
import org.mechio.api.motion.protocol.RobotDefinitionResponse;
import org.mechio.client.basic.ConnectionContext;
import org.mechio.impl.motion.messaging.PortableMotionFrameEvent;
import org.mechio.impl.motion.messaging.PortableRobotDefinitionResponse;
import org.mechio.impl.motion.messaging.PortableRobotRequest;
import org.mechio.impl.motion.messaging.PortableRobotResponse;
import org.mechio.impl.motion.messaging.RobotDefinitionResponseRecord;

final class MioRobotConnector
extends ConnectionContext.MioServiceConnector {
    private static final Logger theLogger = Logger.getLogger(MioRobotConnector.class.getName());
    private static final String theDefaultId = "Avatar_ZenoR50";
    private static final String RESPONSE_RECEIVER = "robotResponseReceiver";
    private static final String REQUEST_SENDER = "robotRequestSender";
    private static final String MOVE_SENDER = "robotMoveSender";
    private static final String DEF_RECEIVER = "robotDefinitionReceiver";
    private static MioRobotConnector theMioRobotConnector;
    private String myRobotIdStr;
    private Robot.Id myRobotId;
    private String myResponseDest;
    private String myRequestDest;
    private String myMoveDest;
    private String myDefDest;
    private RemoteRobotClient myRobotClient;

    static synchronized MioRobotConnector getConnector() {
        if (theMioRobotConnector == null) {
            theMioRobotConnector = new MioRobotConnector();
        }
        return theMioRobotConnector;
    }

    static synchronized void clearConnector() {
        theMioRobotConnector = null;
    }

    public MioRobotConnector() {
        this.setRobotId(theDefaultId);
    }

    void setRobotId(String robotId) {
        if (robotId == null) {
            throw new NullPointerException();
        }
        this.myRobotIdStr = robotId;
        this.myRobotId = new Robot.Id(this.myRobotIdStr);
        String cleanId = this.myRobotIdStr.replaceAll("[^a-zA-Z0-9]+", "");
        this.myResponseDest = "robot" + cleanId + "hostrobotResponse";
        this.myRequestDest = "robot" + cleanId + "hostrobotRequest";
        this.myMoveDest = "robot" + cleanId + "hostmotionFrame";
        this.myDefDest = "robot" + cleanId + "hostrobotDefinition";
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        Destination resp = ConnectionContext.getTopic(this.myResponseDest);
        Destination req = ConnectionContext.getTopic(this.myRequestDest);
        Destination move = ConnectionContext.getTopic(this.myMoveDest);
        Destination def = ConnectionContext.getTopic(this.myDefDest);
        this.myConnectionContext.addBlockingPolyReceiver(RESPONSE_RECEIVER, session, resp, new PortableRobotResponse.RecordMessageAdapter());
        this.myConnectionContext.addSender(REQUEST_SENDER, session, req, new PortableRobotRequest.MessageRecordAdapter());
        this.myConnectionContext.addSender(MOVE_SENDER, session, move, new PortableMotionFrameEvent.MessageRecordAdapter());
        this.myConnectionContext.addAsyncReceiver(DEF_RECEIVER, session, def, RobotDefinitionResponseRecord.class, RobotDefinitionResponseRecord.SCHEMA$, new PortableRobotDefinitionResponse.RecordMessageAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteRobotClient buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        if (this.myRobotClient != null) {
            return this.myRobotClient;
        }
        MessageBlockingReceiver respReceiver = this.myConnectionContext.getBlockingReceiver(RESPONSE_RECEIVER);
        MessageSender reqSender = this.myConnectionContext.getSender(REQUEST_SENDER);
        MessageSender moveSender = this.myConnectionContext.getSender(MOVE_SENDER);
        this.myRobotClient = new RemoteRobotClient(this.myRobotId, "source", "dest", (RobotRequestFactory)new PortableRobotRequest.Factory(), (MotionFrameEvent.MotionFrameEventFactory)new PortableMotionFrameEvent.Factory());
        this.myRobotClient.setResponseReceiver(respReceiver);
        this.myRobotClient.setRequestSender(reqSender);
        this.myRobotClient.setMotionFrameSender(moveSender);
        return this.myRobotClient;
    }

    synchronized MessageAsyncReceiver<RobotDefinitionResponse> getDefReceiver() {
        return this.myConnectionContext.getAsyncReceiver(DEF_RECEIVER);
    }
}

