/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.client.basic;

import java.net.URISyntaxException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.jflux.api.core.util.EmptyAdapter;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.mechio.api.sensor.imu.RemoteGyroscopeServiceClient;
import org.mechio.client.basic.ConnectionContext;
import org.mechio.impl.sensor.FilteredVector3Record;

final class MioGyroscopeConnector
extends ConnectionContext.MioServiceConnector {
    static final String GYRO_VALUE_RECEIVER = "gyroValueReceiver";
    static final String GYRO_CONFIG_SENDER = "gyroConfigSender";
    static final String GYRO_READ_PERIOD_SENDER = "gyroReadPeriodSender";
    private static MioGyroscopeConnector theMioGyroscopeConnector;
    private String theGyroInputDest = "gyroEvent";
    private String theGyroConfigDest = "gyroConfig";
    private String theGyroReadDest = "gyroRead";

    MioGyroscopeConnector() {
    }

    static synchronized MioGyroscopeConnector getConnector() {
        if (theMioGyroscopeConnector == null) {
            theMioGyroscopeConnector = new MioGyroscopeConnector();
        }
        return theMioGyroscopeConnector;
    }

    @Override
    protected synchronized void addConnection(Session session) throws JMSException, URISyntaxException {
        if (this.myConnectionContext == null || this.myConnectionsFlag) {
            return;
        }
        Destination gyroValReceiver = ConnectionContext.getTopic(this.theGyroInputDest);
        this.myConnectionContext.addAsyncReceiver(GYRO_VALUE_RECEIVER, session, gyroValReceiver, FilteredVector3Record.class, FilteredVector3Record.SCHEMA$, new EmptyAdapter());
        Destination gyroCfgSender = ConnectionContext.getTopic(this.theGyroConfigDest);
        this.myConnectionContext.addSender(GYRO_CONFIG_SENDER, session, gyroCfgSender, new EmptyAdapter());
        Destination gyroPerSender = ConnectionContext.getTopic(this.theGyroReadDest);
        this.myConnectionContext.addSender(GYRO_READ_PERIOD_SENDER, session, gyroPerSender, new EmptyAdapter());
        this.myConnectionsFlag = true;
    }

    synchronized RemoteGyroscopeServiceClient buildRemoteClient() {
        if (this.myConnectionContext == null || !this.myConnectionsFlag) {
            return null;
        }
        MessageAsyncReceiver gyroValReceiver = this.myConnectionContext.getAsyncReceiver(GYRO_VALUE_RECEIVER);
        MessageSender gyroCfgSender = this.myConnectionContext.getSender(GYRO_CONFIG_SENDER);
        MessageSender gyroPerSender = this.myConnectionContext.getSender(GYRO_READ_PERIOD_SENDER);
        RemoteGyroscopeServiceClient client = new RemoteGyroscopeServiceClient(gyroCfgSender, gyroPerSender, gyroValReceiver);
        return client;
    }
}

