/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.animation.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.Schema;
import org.jflux.api.core.Adapter;
import org.jflux.impl.messaging.rk.config.RKMessagingConfigUtils;
import org.jflux.impl.services.rk.lifecycle.ServiceLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceFactory;
import org.jflux.impl.services.rk.lifecycle.utils.SimpleLifecycle;
import org.jflux.impl.services.rk.osgi.OSGiUtils;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponent;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponentFactory;
import org.mechio.api.animation.protocol.AnimationEvent;
import org.mechio.api.animation.protocol.AnimationSignal;
import org.mechio.api.animation.protocol.PlayRequest;
import org.mechio.api.animation.xml.AnimationFileReader;
import org.mechio.api.animation.xml.AnimationFileWriter;
import org.mechio.impl.animation.messaging.AnimationEventRecord;
import org.mechio.impl.animation.messaging.AnimationSignallingRecord;
import org.mechio.impl.animation.messaging.PlayRequestRecord;
import org.mechio.impl.animation.messaging.PortableAnimationEvent;
import org.mechio.impl.animation.messaging.PortableAnimationSignal;
import org.mechio.impl.animation.messaging.PortablePlayRequest;
import org.mechio.impl.animation.xml.AnimationXMLReader;
import org.mechio.impl.animation.xml.XPP3AnimationXMLWriter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "AnimationImpl Activation Begin.");
        new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)new AnimationXMLReader(), AnimationFileReader.class)).start();
        new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)new XPP3AnimationXMLWriter(), AnimationFileWriter.class)).start();
        RKMessagingConfigUtils.registerAvroSerializationConfig(AnimationEvent.class, AnimationEventRecord.class, (Schema)AnimationEventRecord.SCHEMA$, (Adapter)new PortableAnimationEvent.MessageRecordAdapter(), (Adapter)new PortableAnimationEvent.RecordMessageAdapter(), (String)"application/avro", null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        RKMessagingConfigUtils.registerAvroSerializationConfig(PlayRequest.class, PlayRequestRecord.class, (Schema)PlayRequestRecord.SCHEMA$, (Adapter)new PortablePlayRequest.MessageRecordAdapter(), (Adapter)new PortablePlayRequest.RecordMessageAdapter(), (String)"application/avro", null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        RKMessagingConfigUtils.registerAvroSerializationConfig(AnimationSignal.class, AnimationSignallingRecord.class, (Schema)AnimationSignallingRecord.SCHEMA$, (Adapter)new PortableAnimationSignal.MessageRecordAdapter(), (Adapter)new PortableAnimationSignal.RecordMessageAdapter(), (String)"application/avro", null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        this.registerSignalFactory(context);
        theLogger.log(Level.INFO, "AnimationImpl Activation Complete.");
    }

    public void stop(BundleContext context) throws Exception {
    }

    private void registerSignalFactory(BundleContext context) {
        if (OSGiUtils.serviceExists((BundleContext)context, AnimationSignal.AnimationSignalFactory.class, null).booleanValue()) {
            return;
        }
        new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)new PortableAnimationSignal.Factory(), AnimationSignal.AnimationSignalFactory.class)).start();
    }
}

