/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.animation.messaging;

import org.jflux.api.common.rk.config.VersionProperty;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.core.Adapter;
import org.mechio.api.animation.protocol.PlayRequest;
import org.mechio.impl.animation.messaging.PlayRequestRecord;

public class PortablePlayRequest
implements PlayRequest {
    private PlayRequestRecord myPlayRequestRecord;

    public PortablePlayRequest(PlayRequestRecord playRec) {
        if (playRec == null) {
            throw new NullPointerException();
        }
        this.myPlayRequestRecord = playRec;
    }

    public PortablePlayRequest(PlayRequest playRequest) {
        PlayRequestRecord rec = new PlayRequestRecord();
        rec.setSourceId(playRequest.getSourceId());
        rec.setDestinationId(playRequest.getDestinationId());
        rec.setCurrentTimeMillisec(playRequest.getCurrentTimeMillisec());
        rec.setAnimationName(playRequest.getAnimationName());
        rec.setAnimationVersionNumber(playRequest.getAnimationVersionNumber());
        this.myPlayRequestRecord = rec;
    }

    public PortablePlayRequest(String sourceId, String destId, long curTimeMillisecUTC, String animName, String animVersionNum) {
        PlayRequestRecord rec = new PlayRequestRecord();
        rec.setSourceId(sourceId);
        rec.setDestinationId(destId);
        rec.setCurrentTimeMillisec(curTimeMillisecUTC);
        rec.setAnimationName(animName);
        rec.setAnimationVersionNumber(animVersionNum);
        this.myPlayRequestRecord = rec;
    }

    public String getSourceId() {
        return this.myPlayRequestRecord.getSourceId();
    }

    public String getDestinationId() {
        return this.myPlayRequestRecord.getDestinationId();
    }

    public Long getCurrentTimeMillisec() {
        return this.myPlayRequestRecord.getCurrentTimeMillisec();
    }

    public String getAnimationName() {
        return this.myPlayRequestRecord.getAnimationName();
    }

    public String getAnimationVersionNumber() {
        return this.myPlayRequestRecord.getAnimationVersionNumber();
    }

    public PlayRequestRecord getRecord() {
        return this.myPlayRequestRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<PlayRequestRecord, PlayRequest> {
        public PlayRequest adapt(PlayRequestRecord a) {
            return new PortablePlayRequest(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<PlayRequest, PlayRequestRecord> {
        public PlayRequestRecord adapt(PlayRequest a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortablePlayRequest(a).getRecord();
        }
    }

    public static class Factory
    implements PlayRequest.PlayRequestFactory {
        public PlayRequest createPlayRequest(String clientId, String hostId, VersionProperty animVersion) {
            if (clientId == null || hostId == null || animVersion == null) {
                throw new NullPointerException();
            }
            return new PortablePlayRequest(clientId, hostId, TimeUtils.now(), animVersion.getName(), animVersion.getNumber());
        }
    }
}

