/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.dynamixel;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.common.rk.utils.Utils;
import org.mechio.impl.motion.dynamixel.DynamixelController;
import org.mechio.impl.motion.dynamixel.DynamixelPacket;
import org.mechio.impl.motion.dynamixel.DynamixelServo;
import org.mechio.impl.motion.dynamixel.enums.Instruction;
import org.mechio.impl.motion.dynamixel.enums.Register;
import org.mechio.impl.motion.dynamixel.feedback.FeedbackUpdateValues;

public class DynamixelMultiReader {
    private static final Logger theLogger = Logger.getLogger(DynamixelMultiReader.class.getName());
    private static final int MULTIREAD_BYTE_COUNT = 8;

    public static synchronized List<FeedbackUpdateValues> getFeedback(DynamixelController controller, List<DynamixelServo.Id> ids) {
        int[][] vals = DynamixelMultiReader.readServos(controller, ids, Register.CurrentPosition, Register.CurrentTemperature);
        if (vals == null) {
            return null;
        }
        long now = TimeUtils.now();
        ArrayList<FeedbackUpdateValues> feedback = new ArrayList<FeedbackUpdateValues>(vals.length);
        boolean error = false;
        for (int i = 0; i < vals.length; ++i) {
            boolean valid = DynamixelMultiReader.validateValues(vals[i]);
            boolean bl = error = error || !valid;
            if (!valid) continue;
            feedback.add(new FeedbackUpdateValues(ids.get(i), vals[i], now));
        }
        return feedback;
    }

    private static boolean validateValues(int[] vals) {
        if (vals == null) {
            return false;
        }
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == 0) continue;
            return true;
        }
        return false;
    }

    private static int[][] readServos(DynamixelController controller, List<DynamixelServo.Id> ids, Register regFirst, Register regLast) {
        byte byteCount = (byte)(regLast.getByte() - regFirst.getByte() + regLast.getLength());
        byte[] cmd = DynamixelMultiReader.buildMultiReadCommand(ids, regFirst.getByte(), byteCount);
        if (!controller.getPort().write(cmd) || !controller.getPort().flushWriter()) {
            return null;
        }
        DynamixelPacket[] packets = DynamixelMultiReader.readPackets(controller, ids.size(), byteCount);
        if (packets == null) {
            return null;
        }
        return DynamixelMultiReader.parsePackets(packets, regFirst, regLast, byteCount);
    }

    private static byte[] buildMultiReadCommand(List<DynamixelServo.Id> ids, byte startRegister, byte byteCount) {
        byte[] data = new byte[ids.size() * 8];
        for (int j = 0; j < ids.size(); ++j) {
            int i = j * 8;
            data[i + 0] = -1;
            data[i + 1] = -1;
            data[i + 2] = (byte)ids.get(j).getIntValue();
            data[i + 3] = 4;
            data[i + 4] = Instruction.ReadData.getByte();
            data[i + 5] = startRegister;
            data[i + 6] = byteCount;
            data[i + 7] = Utils.checksum((byte[])data, (int)(i + 2), (int)5, (boolean)true, (byte[])new byte[0]);
        }
        return data;
    }

    public static DynamixelPacket[] readPackets(DynamixelController controller, int count, byte byteCount) {
        int packetLen = byteCount + 6;
        byte[] data = controller.getPort().read(count * packetLen);
        DynamixelPacket[] packets = new DynamixelPacket[count];
        int offset = DynamixelMultiReader.nextPacket(data, 0);
        for (int i = 0; i < count && offset != -1; ++i) {
            DynamixelPacket p;
            packets[i] = p = DynamixelPacket.parsePacket(data, offset);
            if (p != null && !p.hasError()) {
                if ((offset += p.getData().length + 6) < data.length) continue;
                return packets;
            }
            offset = DynamixelMultiReader.nextPacket(data, offset + 5);
        }
        return packets;
    }

    private static int nextPacket(byte[] data, int offset) {
        if (offset >= data.length - 5) {
            return -1;
        }
        do {
            if (Utils.unsign((byte)data[offset]) != 255 || Utils.unsign((byte)data[offset + 1]) != 255) continue;
            return offset;
        } while (++offset < data.length - 5);
        return -1;
    }

    public static int[][] parsePackets(DynamixelPacket[] packets, Register regFirst, Register regLast, byte byteCount) {
        if (packets == null) {
            return null;
        }
        int first = regFirst.ordinal();
        int last = regLast.ordinal();
        int rows = packets.length;
        int cols = last - first + 1;
        int[][] vals = new int[rows][cols];
        for (int i = 0; i < packets.length; ++i) {
            DynamixelPacket p = packets[i];
            if (p == null || p.getData().length < byteCount) continue;
            DynamixelMultiReader.parsePacketData(first, last, p.getData(), vals[i]);
        }
        return vals;
    }

    private static void parsePacketData(int firstReg, int lastReg, byte[] data, int[] dest) {
        Register[] regs = Register.values();
        for (int i = firstReg; i <= lastReg; ++i) {
            Register reg = regs[i];
            int offset = reg.getByte() - regs[firstReg].getByte();
            dest[i - firstReg] = Utils.unsign((byte)data[offset]);
            if (reg.getLength() <= 1) continue;
            int n = i - firstReg;
            dest[n] = dest[n] + (Utils.unsign((byte)data[offset + 1]) << 8);
        }
    }
}

