/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.dynamixel.feedback;

import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.core.Listener;
import org.mechio.api.motion.servos.ServoController;
import org.mechio.impl.motion.dynamixel.DynamixelController;
import org.mechio.impl.motion.dynamixel.DynamixelMover;
import org.mechio.impl.motion.dynamixel.DynamixelMultiReader;
import org.mechio.impl.motion.dynamixel.DynamixelPacket;
import org.mechio.impl.motion.dynamixel.DynamixelServo;
import org.mechio.impl.motion.dynamixel.feedback.ConcurrentDynamixelCache;
import org.mechio.impl.motion.dynamixel.feedback.DynamixelControlSettings;
import org.mechio.impl.motion.dynamixel.feedback.FeedbackUpdateValues;
import org.mechio.impl.motion.dynamixel.feedback.GoalUpdateValues;
import org.mechio.impl.motion.dynamixel.feedback.MoveParams;
import org.mechio.impl.motion.dynamixel.feedback.TemperatureMonitor;
import org.mechio.impl.motion.openservo.feedback.OpenServoControlLoop;
import org.mechio.impl.motion.rxtx.serial.RXTXSerialPort;

public class DynamixelControlLoop {
    private static final Logger theLogger = Logger.getLogger(DynamixelControlLoop.class.getName());
    private ConcurrentDynamixelCache myCache;
    private DynamixelController myController;
    private List<DynamixelServo.Id> myServoIds;
    private Queue<DynamixelCommand> myCommandQueue;
    private DynamixelControlSettings mySettings;
    private int myReadIndex;
    private boolean myReadOSFlag;
    private boolean myRunFlag;
    private boolean myCooldownFlag;
    private TemperatureMonitor myTemperatureMonitor;
    private OpenServoControlLoop myOSLoop;

    public DynamixelControlLoop(DynamixelController controller, DynamixelControlSettings settings) {
        if (controller == null || settings == null) {
            throw new NullPointerException();
        }
        this.mySettings = settings;
        this.myController = controller;
        this.myCache = new ConcurrentDynamixelCache();
        this.myReadIndex = 0;
        this.myRunFlag = false;
        this.myCooldownFlag = false;
        this.myReadOSFlag = false;
        this.myCommandQueue = new ConcurrentLinkedQueue<DynamixelCommand>();
        this.myTemperatureMonitor = new TemperatureMonitor(this.myController, this.mySettings, this.myCache);
    }

    public void setOpenServoLoop(OpenServoControlLoop loop) {
        this.myOSLoop = loop;
    }

    public DynamixelControlSettings getSettings() {
        return this.mySettings;
    }

    public void setGoalPositions(Collection<GoalUpdateValues<DynamixelServo.Id>> goals) {
        this.myCache.setGoalPositions(goals);
    }

    public void start(List<DynamixelServo.Id> ids) {
        if (this.myRunFlag || ids == null) {
            return;
        }
        this.mySettings.setRunFlag(true);
        this.myRunFlag = true;
        this.myServoIds = ids;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DynamixelControlLoop.this.commandLoop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }).start();
    }

    public void stop() {
        this.myRunFlag = false;
        this.mySettings.setRunFlag(false);
    }

    private void commandLoop() {
        while (this.myRunFlag) {
            try {
                if (!this.mySettings.getRunFlag()) {
                    TimeUtils.sleep((long)10L);
                    continue;
                }
                if (this.cooldown()) {
                    if (this.mySettings.getCommandFlag()) {
                        this.commandBoth();
                    }
                    this.update();
                    continue;
                }
                if (this.mySettings.getMoveFlag() && (this.myCache.getMoveFlag() || this.myOSLoop != null && this.myOSLoop.getMoveFlag())) {
                    if (this.myCache.getMoveFlag()) {
                        this.move();
                    }
                    if (this.myOSLoop == null || !this.myOSLoop.getMoveFlag()) continue;
                    this.myOSLoop.move();
                    continue;
                }
                if (this.mySettings.getCommandFlag() && this.commandBoth() || !this.mySettings.getUpdateFlag()) continue;
                this.update();
            }
            catch (Throwable t) {
                theLogger.log(Level.WARNING, "Recovering from error in Dynamixel control loop: ", t);
                TimeUtils.sleep((long)5L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void move() {
        Collection<MoveParams<DynamixelServo.Id>> params = this.myCache.acquireMoveParams();
        try {
            if (params == null || params.isEmpty()) {
                return;
            }
            if (!DynamixelMover.moveServos(this.myController, params, this.mySettings)) {
                theLogger.warning("There was an error moving the dynamixels.");
                this.myController.getPort().clearErrors();
            } else {
                this.myCache.setMoveFlag(false);
            }
        }
        finally {
            this.myCache.releaseMoveParams();
        }
    }

    private boolean cooldown() {
        this.myTemperatureMonitor.disableHotServos((int)this.mySettings.getMaxRunTemperature());
        return false;
    }

    private synchronized void update() {
        if (this.myReadOSFlag) {
            this.myReadOSFlag = this.myOSLoop == null ? false : this.myOSLoop.update();
            return;
        }
        int from = this.myReadIndex;
        int to = Math.min(this.myReadIndex + this.mySettings.getReadCount(), this.myServoIds.size());
        List<DynamixelServo.Id> ids = this.myServoIds.subList(from, to);
        List<FeedbackUpdateValues> feedback = DynamixelMultiReader.getFeedback(this.myController, ids);
        if (feedback == null) {
            this.clearControllerErrors();
            return;
        }
        if (feedback.size() < ids.size()) {
            this.clearControllerErrors();
        }
        this.myCache.addFeedbackValues(feedback);
        this.myReadIndex += this.mySettings.getReadCount();
        if (this.myReadIndex >= this.myServoIds.size()) {
            this.myReadIndex = 0;
            this.myReadOSFlag = true;
        }
        this.updateServoValues(feedback);
    }

    private void clearControllerErrors() {
        TimeUtils.sleep((long)1L);
        this.myController.getPort().clearErrors();
        this.myController.getPort().clearReader();
    }

    private void updateServoValues(List<FeedbackUpdateValues> feedbackVals) {
        for (FeedbackUpdateValues val : feedbackVals) {
            ServoController.ServoId id;
            DynamixelServo servo;
            if (val == null || val.getCurrentTemperature() == 0 || val.getCurrentVoltage() == 0 || (servo = (DynamixelServo)this.myController.getServo(id = new ServoController.ServoId(this.myController.getId(), (Object)val.getServoId()))) == null) continue;
            servo.setFeedbackVals(val);
        }
    }

    public void queueCommand(DynamixelCommand cmd) {
        if (cmd == null) {
            return;
        }
        this.myCommandQueue.add(cmd);
        if (!this.myRunFlag) {
            this.command();
        }
    }

    public synchronized boolean commandBoth() {
        boolean ret = this.command();
        if (this.myOSLoop != null) {
            ret = ret || this.myOSLoop.command();
        }
        return ret;
    }

    public synchronized boolean command() {
        boolean write;
        if (this.myCommandQueue.isEmpty()) {
            return false;
        }
        DynamixelCommand cmd = this.myCommandQueue.poll();
        if (cmd == null) {
            return false;
        }
        RXTXSerialPort port = this.myController.getPort();
        if (port == null) {
            cmd.myPacketCallback.handleEvent(null);
            return false;
        }
        boolean bl = write = port.write(cmd.myCommandBytes) && port.flushWriter();
        if (!write) {
            cmd.myPacketCallback.handleEvent(null);
            return false;
        }
        return cmd.myPacketCount <= 0 || this.read(cmd.myPacketCount, cmd.myPacketDataSize, cmd.myPacketCallback);
    }

    private boolean read(int i, byte packetSize, Listener<DynamixelPacket[]> callback) {
        DynamixelPacket[] packets = DynamixelMultiReader.readPackets(this.myController, i, packetSize);
        if (callback != null) {
            callback.handleEvent((Object)packets);
        }
        return packets != null && packets.length == i;
    }

    public static class PacketCallback
    implements Listener<DynamixelPacket[]> {
        private DynamixelPacket[] myPackets;
        private long myStartTime;
        private boolean myReceivedFlag = false;

        public void handleEvent(DynamixelPacket[] packets) {
            this.myPackets = packets;
            this.myReceivedFlag = true;
        }

        public DynamixelPacket[] waitForPackets(long timeout) {
            this.myStartTime = TimeUtils.now();
            while (!this.myReceivedFlag) {
                if (TimeUtils.now() >= this.myStartTime + timeout) {
                    return null;
                }
                TimeUtils.sleep((long)1L);
            }
            return this.myPackets;
        }

        public boolean packetsReceived() {
            return this.myReceivedFlag;
        }
    }

    public static class DynamixelCommand {
        public byte[] myCommandBytes;
        public int myPacketCount;
        public byte myPacketDataSize;
        public PacketCallback myPacketCallback;

        public DynamixelCommand(byte[] cmdBytes, int packetCount, byte packetDataSize, PacketCallback packetCallback) {
            this.myCommandBytes = cmdBytes;
            this.myPacketCount = packetCount;
            this.myPacketDataSize = packetDataSize;
            this.myPacketCallback = packetCallback;
        }

        public int getPacketReturnCount() {
            return this.myPacketCount;
        }

        public PacketCallback getCallback() {
            return this.myPacketCallback;
        }
    }
}

