/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.openservo.feedback;

import org.mechio.impl.motion.dynamixel.feedback.GoalUpdateValues;
import org.mechio.impl.motion.dynamixel.feedback.MoveParams;
import org.mechio.impl.motion.openservo.OpenServo;
import org.mechio.impl.motion.openservo.feedback.OpenServoFeedbackValues;

public class OpenServoCache
implements MoveParams<OpenServo.Id> {
    private OpenServo.Id myId;
    private OpenServoFeedbackValues myFeedbackVals;
    private GoalUpdateValues<OpenServo.Id> myGoalValues;
    private GoalUpdateValues<OpenServo.Id> myPrevGoalValues;
    private long myCommandDelayMiiilsec;

    public OpenServoCache(OpenServo.Id id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.myId = id;
        this.myPrevGoalValues = new GoalUpdateValues<OpenServo.Id>(id, 0, 0L);
        this.myGoalValues = new GoalUpdateValues<OpenServo.Id>(id, 0, 0L);
        this.myFeedbackVals = new OpenServoFeedbackValues(id, new int[5], 0L);
        this.myCommandDelayMiiilsec = 2L;
    }

    @Override
    public OpenServo.Id getServoId() {
        return this.myId;
    }

    public void setFeedbackVals(OpenServoFeedbackValues vals) {
        this.myFeedbackVals = vals;
    }

    public void setGoalVals(GoalUpdateValues vals) {
        this.myGoalValues = vals;
    }

    @Override
    public void goalsSent() {
        this.myPrevGoalValues = this.myGoalValues;
    }

    @Override
    public int getCurrentPosition() {
        return this.myFeedbackVals.getCurrentPosition();
    }

    @Override
    public int getCurrentSpeed() {
        return this.myFeedbackVals.getCurrentSpeed();
    }

    @Override
    public int getCurrentVoltage() {
        return this.myFeedbackVals.getCurrentVoltage();
    }

    @Override
    public int getCurrentTemperature() {
        return -1;
    }

    @Override
    public int getCurrentLoad() {
        return this.myFeedbackVals.getCurrentLoad();
    }

    @Override
    public long getCommandDelayMillisec() {
        return this.myCommandDelayMiiilsec;
    }

    @Override
    public long getCurPosTimestampUTC() {
        return this.myFeedbackVals.getUpdateTimestamp();
    }

    @Override
    public long getPrevGoalTargetTimeUTC() {
        return this.myPrevGoalValues.getGoalTargetTimeUTC();
    }

    @Override
    public int getPrevGoalPosition() {
        return this.myPrevGoalValues.getGoalPosition();
    }

    @Override
    public long getGoalTargetTimeUTC() {
        return this.myGoalValues.getGoalTargetTimeUTC();
    }

    @Override
    public int getGoalPosition() {
        return this.myGoalValues.getGoalPosition();
    }

    public OpenServoFeedbackValues getFeedback() {
        return this.myFeedbackVals;
    }

    public void setCommandDelayMillisec(long msec) {
        this.myCommandDelayMiiilsec = msec;
    }
}

