/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.dynamixel.feedback;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mechio.impl.motion.dynamixel.DynamixelServo;
import org.mechio.impl.motion.dynamixel.feedback.DynamixelServoCache;
import org.mechio.impl.motion.dynamixel.feedback.FeedbackUpdateValues;
import org.mechio.impl.motion.dynamixel.feedback.GoalUpdateValues;
import org.mechio.impl.motion.dynamixel.feedback.MoveParams;

public class ConcurrentDynamixelCache {
    private Map<DynamixelServo.Id, DynamixelServoCache> myValueMap = new HashMap<DynamixelServo.Id, DynamixelServoCache>();
    private Map<DynamixelServo.Id, FeedbackUpdateValues> myFeedbackQueue = new HashMap<DynamixelServo.Id, FeedbackUpdateValues>();
    private Map<DynamixelServo.Id, GoalUpdateValues<DynamixelServo.Id>> myGoalParamQueue = new HashMap<DynamixelServo.Id, GoalUpdateValues<DynamixelServo.Id>>();
    private Lock myValueLock = new ReentrantLock();
    private boolean myMoveFlag = false;

    synchronized Collection<MoveParams<DynamixelServo.Id>> acquireMoveParams() {
        this.myValueLock.lock();
        return this.myValueMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void releaseMoveParams() {
        try {
            this.mergeFeedback(this.myFeedbackQueue.values());
            this.mergeGoals(this.myGoalParamQueue.values());
            this.myFeedbackQueue.clear();
            this.myGoalParamQueue.clear();
        }
        finally {
            this.myValueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addFeedbackValues(Collection<FeedbackUpdateValues> values) {
        if (this.myValueLock.tryLock()) {
            try {
                this.mergeFeedback(values);
            }
            finally {
                this.myValueLock.unlock();
            }
        } else {
            this.queueFeedback(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setGoalPositions(Collection<GoalUpdateValues<DynamixelServo.Id>> goals) {
        if (this.myValueLock.tryLock()) {
            try {
                this.mergeGoals(goals);
            }
            finally {
                this.myValueLock.unlock();
            }
        } else {
            this.queueGoals(goals);
        }
    }

    private void queueFeedback(Collection<FeedbackUpdateValues> vals) {
        for (FeedbackUpdateValues val : vals) {
            if (val.getCurrentTemperature() == 0 || val.getCurrentVoltage() == 0) continue;
            this.myFeedbackQueue.put(val.getServoId(), val);
        }
    }

    private void mergeFeedback(Collection<FeedbackUpdateValues> vals) {
        for (FeedbackUpdateValues val : vals) {
            DynamixelServo.Id id = val.getServoId();
            DynamixelServoCache cache = this.myValueMap.get(id);
            if (cache == null) {
                cache = new DynamixelServoCache(id);
                cache.setGoalVals(new GoalUpdateValues<DynamixelServo.Id>(id, -1, 0L));
                cache.goalsSent();
                this.myValueMap.put(id, cache);
            }
            cache.setFeedbackVals(val);
        }
    }

    private void queueGoals(Collection<GoalUpdateValues<DynamixelServo.Id>> vals) {
        for (GoalUpdateValues<DynamixelServo.Id> val : vals) {
            this.myGoalParamQueue.put(val.getServoId(), val);
        }
    }

    private void mergeGoals(Collection<GoalUpdateValues<DynamixelServo.Id>> goals) {
        for (GoalUpdateValues<DynamixelServo.Id> val : goals) {
            DynamixelServo.Id id = val.getServoId();
            DynamixelServoCache cache = this.myValueMap.get(id);
            if (cache == null) {
                cache = new DynamixelServoCache(id);
                cache.setFeedbackVals(new FeedbackUpdateValues(id, new int[5], 0L));
                this.myValueMap.put(id, cache);
            }
            cache.setGoalVals(val);
        }
        if (!goals.isEmpty()) {
            this.setMoveFlag(true);
        }
    }

    synchronized boolean getMoveFlag() {
        return this.myMoveFlag;
    }

    synchronized void setMoveFlag(boolean val) {
        this.myMoveFlag = val;
    }

    public Map<DynamixelServo.Id, DynamixelServoCache> getValueMap() {
        return this.myValueMap;
    }
}

