/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.openservo.feedback;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.jflux.api.core.Source;
import org.mechio.api.motion.servos.ServoController;
import org.mechio.impl.motion.dynamixel.DynamixelPacket;
import org.mechio.impl.motion.dynamixel.feedback.DynamixelControlLoop;
import org.mechio.impl.motion.dynamixel.feedback.DynamixelControlSettings;
import org.mechio.impl.motion.dynamixel.feedback.MoveParams;
import org.mechio.impl.motion.openservo.OpenServo;
import org.mechio.impl.motion.openservo.OpenServoCommandSet;
import org.mechio.impl.motion.openservo.OpenServoController;
import org.mechio.impl.motion.openservo.feedback.ConcurrentOpenServoCache;
import org.mechio.impl.motion.openservo.feedback.OpenServoFeedbackValues;
import org.mechio.impl.motion.openservo.feedback.OpenServoReader;
import org.mechio.impl.motion.rxtx.serial.RXTXSerialPort;

public class OpenServoControlLoop {
    private static final Logger theLogger = Logger.getLogger(OpenServoControlLoop.class.getName());
    private ConcurrentOpenServoCache myCache;
    private OpenServoController myController;
    private List<OpenServo.Id> myServoIds;
    private Queue<DynamixelControlLoop.DynamixelCommand> myCommandQueue;
    private DynamixelControlSettings mySettings;
    private int myReadIndex;
    private boolean myRunFlag;
    private Source<RXTXSerialPort> myPortSource;
    private static int THE_OPEN_SERVO_READ_DELAY_COUNT = 0;
    private static int THE_OPEN_SERVO_READ_DELAY_THRESHOLD = 10;

    public OpenServoControlLoop(OpenServoController controller, DynamixelControlSettings settings) {
        if (controller == null || settings == null) {
            throw new NullPointerException();
        }
        this.mySettings = settings;
        this.myController = controller;
        this.myCache = controller.getCache();
        this.myReadIndex = 0;
        this.myRunFlag = false;
        this.myCommandQueue = new ConcurrentLinkedQueue<DynamixelControlLoop.DynamixelCommand>();
    }

    public void setPortSource(Source<RXTXSerialPort> port) {
        this.myPortSource = port;
    }

    public DynamixelControlSettings getSettings() {
        return this.mySettings;
    }

    public void start(List<OpenServo.Id> ids) {
        if (this.myRunFlag || ids == null) {
            return;
        }
        this.mySettings.setRunFlag(true);
        this.myRunFlag = true;
        this.myServoIds = ids;
    }

    public void stop() {
        this.myRunFlag = false;
        this.mySettings.setRunFlag(false);
    }

    public boolean getMoveFlag() {
        return this.myCache.getMoveFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void move() {
        if (this.myPortSource == null || this.myPortSource.getValue() == null) {
            return;
        }
        Collection<MoveParams<OpenServo.Id>> params = this.myCache.acquireMoveParams();
        try {
            if (params == null || params.isEmpty()) {
                return;
            }
            if (!this.moveServos(this.myController, params, this.mySettings)) {
                theLogger.warning("There was an error moving the OpenServos.");
            } else {
                this.myCache.setMoveFlag(false);
            }
        }
        finally {
            this.myCache.releaseMoveParams();
        }
    }

    public synchronized boolean update() {
        boolean ret;
        if (this.myPortSource == null || this.myPortSource.getValue() == null) {
            return false;
        }
        if (THE_OPEN_SERVO_READ_DELAY_COUNT < THE_OPEN_SERVO_READ_DELAY_THRESHOLD) {
            ++THE_OPEN_SERVO_READ_DELAY_COUNT;
            return false;
        }
        THE_OPEN_SERVO_READ_DELAY_COUNT = 0;
        int from = this.myReadIndex;
        int to = Math.min(this.myReadIndex + this.mySettings.getReadCount(), this.myServoIds.size());
        List<OpenServo.Id> ids = this.myServoIds.subList(from, to);
        if (ids.isEmpty()) {
            return false;
        }
        OpenServoFeedbackValues feedback = OpenServoReader.getFeedback((RXTXSerialPort)this.myPortSource.getValue(), ids.get(0));
        if (feedback == null) {
            return false;
        }
        List<OpenServoFeedbackValues> vals = Arrays.asList(feedback);
        this.myCache.addFeedbackValues(vals);
        this.myReadIndex += this.mySettings.getReadCount();
        boolean bl = ret = this.myReadIndex < this.myServoIds.size();
        if (!ret) {
            this.myReadIndex = 0;
        }
        this.updateServoValues(vals);
        return false;
    }

    private void updateServoValues(List<OpenServoFeedbackValues> feedbackVals) {
        for (OpenServoFeedbackValues val : feedbackVals) {
            ServoController.ServoId id;
            OpenServo servo;
            if (val == null || val.getCurrentVoltage() == 0 || (servo = (OpenServo)this.myController.getServo(id = new ServoController.ServoId(this.myController.getId(), (Object)val.getServoId()))) == null) continue;
            servo.setFeedbackVals(val);
        }
    }

    public void queueCommand(DynamixelControlLoop.DynamixelCommand cmd) {
        if (cmd == null) {
            return;
        }
        this.myCommandQueue.add(cmd);
        if (!this.myRunFlag) {
            this.command();
        }
    }

    public synchronized boolean command() {
        boolean write;
        if (this.myCommandQueue.isEmpty()) {
            return false;
        }
        if (this.myPortSource == null || this.myPortSource.getValue() == null) {
            return false;
        }
        DynamixelControlLoop.DynamixelCommand cmd = this.myCommandQueue.poll();
        if (cmd == null) {
            return false;
        }
        if (this.myPortSource == null || this.myPortSource.getValue() == null) {
            if (cmd.myPacketCallback != null) {
                cmd.myPacketCallback.handleEvent(null);
            }
            return false;
        }
        boolean bl = write = ((RXTXSerialPort)this.myPortSource.getValue()).write(cmd.myCommandBytes) && ((RXTXSerialPort)this.myPortSource.getValue()).flushWriter();
        if (!write) {
            if (cmd.myPacketCallback != null) {
                cmd.myPacketCallback.handleEvent(null);
            }
            return false;
        }
        return cmd.myPacketCount <= 0 || this.read(cmd.myPacketCount, cmd.myPacketDataSize, cmd.myPacketCallback);
    }

    private boolean read(int i, byte packetSize, Listener<DynamixelPacket[]> callback) {
        DynamixelPacket[] packets = this.readPackets(this.myController, i, packetSize);
        if (callback != null) {
            callback.handleEvent((Object)packets);
        }
        return packets != null && packets.length == i;
    }

    private boolean moveServos(OpenServoController controller, Collection<MoveParams<OpenServo.Id>> params, DynamixelControlSettings settings) {
        boolean ret = true;
        for (MoveParams<OpenServo.Id> p : params) {
            ret = this.moveServo(p) && ret;
        }
        return ret;
    }

    private boolean moveServo(MoveParams<OpenServo.Id> params) {
        if (this.myPortSource == null) {
            return false;
        }
        OpenServo.Id id = params.getServoId();
        byte rs485Addr = (byte)id.getRS485Addr();
        byte i2cAddr = (byte)id.getI2CAddr();
        byte[] cmd = OpenServoCommandSet.move(rs485Addr, i2cAddr, params.getGoalPosition());
        ((RXTXSerialPort)this.myPortSource.getValue()).write(cmd);
        ((RXTXSerialPort)this.myPortSource.getValue()).flushWriter();
        return true;
    }

    private List<OpenServoFeedbackValues> getFeedback(OpenServoController controller, List<OpenServo.Id> ids) {
        return null;
    }

    private DynamixelPacket[] readPackets(OpenServoController controller, int count, byte packetSize) {
        return null;
    }
}

