/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.dynamixel;

import org.jflux.api.common.rk.utils.Utils;
import org.mechio.impl.motion.dynamixel.DynamixelMultiReader;
import org.mechio.impl.motion.dynamixel.DynamixelPacket;
import org.mechio.impl.motion.dynamixel.DynamixelServo;
import org.mechio.impl.motion.dynamixel.enums.Instruction;
import org.mechio.impl.motion.dynamixel.enums.Register;
import org.mechio.impl.motion.dynamixel.feedback.DynamixelControlLoop;

public class DynamixelCommandSender {
    public static boolean ping(DynamixelControlLoop controlLoop, DynamixelServo.Id id, long timeout) {
        DynamixelPacket[] packets = DynamixelCommandSender.sendCommand(controlLoop, id, Instruction.Ping, new byte[0], 1, (byte)0, timeout);
        if (packets == null || packets.length == 0 || packets[0] == null) {
            return false;
        }
        return !packets[0].hasError();
    }

    public static int[] readRegisters(DynamixelControlLoop controlLoop, DynamixelServo.Id id, Register first, Register last, long timeout) {
        byte byteCount = (byte)(last.getByte() - first.getByte() + last.getLength());
        DynamixelPacket[] packets = DynamixelCommandSender.sendCommand(controlLoop, id, Instruction.ReadData, new byte[]{first.getByte(), byteCount}, 1, byteCount, timeout);
        if (packets == null) {
            return null;
        }
        int[][] data = DynamixelMultiReader.parsePackets(packets, first, last, byteCount);
        if (data == null || data.length == 0) {
            return null;
        }
        return data[0];
    }

    public static boolean writeRegister(DynamixelControlLoop controlLoop, DynamixelServo.Id id, Register reg, Integer value, long timeout) {
        byte[] params = new byte[reg.getLength() + 1];
        params[0] = reg.getByte();
        int len = reg.getLength();
        if (len == 1) {
            params[1] = value.byteValue();
        } else {
            params[1] = (byte)(value & 0xFF);
            params[2] = (byte)(value >> 8);
        }
        DynamixelPacket[] packets = DynamixelCommandSender.sendCommand(controlLoop, id, Instruction.WriteData, params, 1, (byte)0, timeout);
        if (packets == null || packets.length == 0 || packets[0] == null) {
            return false;
        }
        return !packets[0].hasError();
    }

    private static DynamixelPacket[] sendCommand(DynamixelControlLoop controlLoop, DynamixelServo.Id id, Instruction ins, byte[] params, int readCount, byte readBytes, long timeout) {
        return DynamixelCommandSender.sendAndWait(controlLoop, DynamixelCommandSender.buildCommand(id, ins, params, readCount, readBytes), timeout);
    }

    private static DynamixelPacket[] sendAndWait(DynamixelControlLoop controlLoop, DynamixelControlLoop.DynamixelCommand cmd, long timeout) {
        if (controlLoop == null || cmd == null) {
            return null;
        }
        controlLoop.queueCommand(cmd);
        if (cmd.getPacketReturnCount() > 0) {
            return cmd.getCallback().waitForPackets(timeout);
        }
        return new DynamixelPacket[0];
    }

    public static DynamixelControlLoop.DynamixelCommand buildCommand(DynamixelServo.Id id, Instruction ins, byte[] params, int readCount, byte readBytes) {
        DynamixelControlLoop.PacketCallback callback = new DynamixelControlLoop.PacketCallback();
        byte[] cmd = DynamixelCommandSender.buildInstruction(id, ins, params);
        return new DynamixelControlLoop.DynamixelCommand(cmd, readCount, readBytes, callback);
    }

    private static byte[] buildInstruction(DynamixelServo.Id id, Instruction ins, byte ... params) {
        int paramLen = params == null ? 0 : params.length;
        byte[] data = new byte[6 + paramLen];
        data[0] = -1;
        data[1] = -1;
        data[2] = (byte)id.getIntValue();
        data[3] = (byte)(paramLen + 2);
        data[4] = ins.getByte();
        System.arraycopy(params, 0, data, 5, paramLen);
        data[data.length - 1] = Utils.checksum((byte[])data, (int)2, (int)(paramLen + 3), (boolean)true, (byte[])new byte[0]);
        return data;
    }
}

