/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.dynamixel;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.utils.Utils;
import org.mechio.impl.motion.dynamixel.DynamixelController;
import org.mechio.impl.motion.dynamixel.DynamixelServo;
import org.mechio.impl.motion.dynamixel.enums.ErrorStatus;

public class DynamixelPacket {
    private static final Logger theLogger = Logger.getLogger(DynamixelPacket.class.getName());
    private DynamixelServo.Id myId = DynamixelController.BROADCAST_ID;
    private byte[] myData;
    private int myLength;
    private boolean myErrorFlag;
    private List<ErrorStatus> myErrors;

    public static DynamixelPacket parsePacket(byte[] data, int offset) {
        boolean badId;
        if (data.length - offset < 6) {
            theLogger.log(Level.INFO, "Error reading Dynamixel Packet, too few bytes.  Data Length: {0}, offset: {1}", new Object[]{data.length, offset});
            return null;
        }
        int first = Utils.unsign((byte)data[offset]);
        int second = Utils.unsign((byte)data[offset + 1]);
        if (first != 255 || second != 255) {
            theLogger.log(Level.INFO, "Error reading Dynamixel Packet.  Incorrect header bytes.Data Length: {0}, offset: {1}, first: {2}, second: {3}", new Object[]{data.length, offset, first, second});
            return null;
        }
        DynamixelPacket packet = new DynamixelPacket();
        int receivedId = Utils.unsign((byte)data[offset + 2]);
        packet.myLength = Utils.unsign((byte)data[offset + 3]) - 2;
        if (packet.myLength > data.length - (offset + 6)) {
            theLogger.log(Level.INFO, "Error reading Dynamixel Packet, too few bytes.  Data Length: {0}, Offset: {1}, Packet Length: {2}", new Object[]{data.length, offset, packet.myLength});
            return null;
        }
        int errorBits = Utils.unsign((byte)data[offset + 4]);
        packet.myErrors = ErrorStatus.getStatusList(errorBits);
        int plen = packet.myLength;
        if (plen < 0) {
            theLogger.log(Level.INFO, "Error reading Dynamixel Packet.  Negative packet length.");
            return null;
        }
        packet.myData = new byte[packet.myLength];
        System.arraycopy(data, offset + 5, packet.myData, 0, packet.myLength);
        packet.myErrorFlag = packet.myLength != packet.myData.length;
        byte chkCalc = Utils.checksum((byte[])packet.myData, (int)0, (int)packet.myData.length, (boolean)true, (byte[])new byte[]{(byte)receivedId, (byte)(packet.myLength + 2), (byte)errorBits});
        byte chkRec = data[offset + 5 + packet.myLength];
        boolean chksum = chkCalc != chkRec;
        boolean dataLen = packet.myLength != packet.myData.length;
        boolean errorFlag = !packet.myErrors.isEmpty();
        boolean bl = badId = !DynamixelServo.Id.isValidId(receivedId);
        if (!badId) {
            packet.myId = new DynamixelServo.Id(receivedId);
        }
        boolean bl2 = packet.myErrorFlag = chksum || dataLen || errorFlag || badId;
        if (!packet.myErrorFlag) {
            return packet;
        }
        theLogger.log(Level.INFO, "Bad Packet Received:\n{0}", DynamixelPacket.str(packet));
        if (chksum) {
            theLogger.log(Level.INFO, "Error reading Dynamixel packet. Bad checksum.");
            return null;
        }
        if (dataLen) {
            theLogger.log(Level.WARNING, "Error reading Dynamixel packet.  Data not recieved.");
            return null;
        }
        if (errorFlag) {
            int len = packet.myErrors.size();
            String errorStr = "";
            for (int j = 0; j < len; ++j) {
                ErrorStatus e = packet.myErrors.get(j);
                errorStr = errorStr + e.name();
                errorStr = errorStr + (j < len - 1 ? ", " : ".");
            }
            theLogger.log(Level.WARNING, "Dynamixel Error - id: {0}, error: {1}", new Object[]{packet.myId.toString(), errorStr});
        }
        if (badId) {
            theLogger.log(Level.WARNING, "Error reading Dynamixel packet.  Invalid Id Recieved.");
            return null;
        }
        return packet;
    }

    private DynamixelPacket() {
    }

    public DynamixelServo.Id getId() {
        return this.myId;
    }

    public byte[] getData() {
        return this.myData;
    }

    public boolean hasError() {
        return this.myErrorFlag;
    }

    public List<ErrorStatus> getErrors() {
        return this.myErrors;
    }

    private static String str(DynamixelPacket packet) {
        StringBuilder builder = new StringBuilder();
        builder.append("id: ").append(packet.getId()).append(", length: ").append(packet.myLength);
        builder.append(", has error: ").append(packet.hasError());
        byte[] data = packet.getData();
        if (data != null) {
            builder.append("\ndata: ").append(Arrays.toString(data));
        } else {
            builder.append(", data: null");
        }
        List<ErrorStatus> errors = packet.getErrors();
        if (errors != null && !errors.isEmpty()) {
            builder.append("\nerrors: ").append(Arrays.toString(packet.myErrors.toArray()));
        }
        return builder.toString();
    }
}

