/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.dynamixel.properties;

import org.jflux.api.common.rk.position.DoubleRange;
import org.jflux.api.common.rk.position.NormalizableRange;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.jflux.api.common.rk.types.Temperature;
import org.mechio.api.motion.joint_properties.ReadTemperature;
import org.mechio.impl.motion.dynamixel.DynamixelServo;

public class TemperatureProperty
extends ReadTemperature {
    private DynamixelServo myDynamixelServo;
    protected Temperature myCachedValue;

    public TemperatureProperty(DynamixelServo dyna) {
        if (dyna == null) {
            throw new NullPointerException();
        }
        this.myDynamixelServo = dyna;
    }

    public Temperature getValue() {
        Temperature old = this.myCachedValue;
        this.myCachedValue = this.readValue();
        this.firePropertyChange(this.getPropertyName(), old, this.myCachedValue);
        return this.myCachedValue;
    }

    private Temperature readValue() {
        Integer temperature = this.myDynamixelServo.getCurrentTemperature();
        if (temperature != null) {
            return new Temperature((double)temperature.intValue());
        }
        return null;
    }

    public NormalizableRange<Temperature> getNormalizableRange() {
        return new NormalizableRange<Temperature>(){
            private DoubleRange myDoubleRange = new DoubleRange(0.0, 1000.0);

            public boolean isValid(Temperature t) {
                return this.myDoubleRange.isValid(Double.valueOf(t.getDegreesCelsius()));
            }

            public NormalizedDouble normalizeValue(Temperature t) {
                return this.myDoubleRange.normalizeValue(Double.valueOf(t.getDegreesCelsius()));
            }

            public Temperature denormalizeValue(NormalizedDouble v) {
                return new Temperature(this.myDoubleRange.denormalizeValue(v).doubleValue());
            }

            public Temperature getMin() {
                return new Temperature(this.myDoubleRange.getMin().doubleValue());
            }

            public Temperature getMax() {
                return new Temperature(this.myDoubleRange.getMax().doubleValue());
            }
        };
    }
}

