/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.openservo.feedback;

import java.util.logging.Logger;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.mechio.api.motion.servos.utils.ConnectionStatus;
import org.mechio.impl.motion.openservo.OpenServo;
import org.mechio.impl.motion.openservo.OpenServoCommandSet;
import org.mechio.impl.motion.openservo.OpenServoPacket;
import org.mechio.impl.motion.openservo.feedback.OpenServoFeedbackValues;
import org.mechio.impl.motion.rxtx.serial.RXTXSerialPort;

public class OpenServoReader {
    private static final Logger theLogger = Logger.getLogger(OpenServoReader.class.getName());

    public static synchronized OpenServoFeedbackValues getFeedback(RXTXSerialPort port, OpenServo.Id id) {
        if (port == null || ConnectionStatus.CONNECTED != port.getConnectionStatus()) {
            return null;
        }
        int[] vals = OpenServoReader.readServo(port, id, OpenServoCommandSet.Register.POSITION_HI, OpenServoCommandSet.Register.VOLTAGE_LO);
        if (vals == null) {
            return null;
        }
        long now = TimeUtils.now();
        if (OpenServoReader.validateValues(vals)) {
            return new OpenServoFeedbackValues(id, vals, now);
        }
        return null;
    }

    private static boolean validateValues(int[] vals) {
        return true;
    }

    private static int[] readServo(RXTXSerialPort port, OpenServo.Id id, OpenServoCommandSet.Register regFirst, OpenServoCommandSet.Register regLast) {
        byte byteCount = (byte)(regLast.getRegister() - regFirst.getRegister() + 1);
        byte[] cmd = OpenServoReader.buildReadCommand(id, regFirst, byteCount);
        if (!port.write(cmd) || !port.flushWriter()) {
            return null;
        }
        OpenServoPacket packet = OpenServoReader.readPacket(port, byteCount);
        if (packet == null) {
            return null;
        }
        return OpenServoReader.parsePacket(packet, byteCount);
    }

    private static byte[] buildReadCommand(OpenServo.Id id, OpenServoCommandSet.Register startRegister, int regCount) {
        return OpenServoCommandSet.readRegisters(id.getRS485Addr(), id.getI2CAddr(), startRegister, regCount);
    }

    public static OpenServoPacket readPacket(RXTXSerialPort port, byte byteCount) {
        int packetLen = byteCount + 5;
        byte[] data = port.read(packetLen);
        return OpenServoPacket.parsePacket(data, 0);
    }

    public static int[] parsePacket(OpenServoPacket packet, byte byteCount) {
        if (packet == null || packet.getData().length < byteCount) {
            return null;
        }
        int[] vals = new int[byteCount / 2];
        byte[] data = packet.getData();
        int j = 0;
        for (int i = 0; j < vals.length && i < byteCount - 1; i += 2, ++j) {
            int hi = (data[i] & 0xFF) << 8;
            int lo = data[i + 1] & 0xFF;
            vals[j] = hi + lo;
        }
        return vals;
    }
}

