/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.dynamixel;

import java.util.ArrayList;
import java.util.Collection;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.common.rk.utils.Utils;
import org.mechio.api.motion.servos.ServoController;
import org.mechio.impl.motion.dynamixel.DynamixelController;
import org.mechio.impl.motion.dynamixel.DynamixelServo;
import org.mechio.impl.motion.dynamixel.enums.Instruction;
import org.mechio.impl.motion.dynamixel.enums.Register;
import org.mechio.impl.motion.dynamixel.feedback.DynamixelControlSettings;
import org.mechio.impl.motion.dynamixel.feedback.MoveParams;
import org.mechio.impl.motion.rxtx.serial.RXTXSerialPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamixelMover {
    private static final Logger theLogger = LoggerFactory.getLogger(DynamixelMover.class);
    private static final int theSyncCount = 5;
    private static final double theRXMaxPosition = 1023.0;
    private static final double theRXRotationRange = 300.0;
    private static final double theRXRPMConversion = 0.111;
    private static final double theMXMaxPosition = 4095.0;
    private static final double theMXRotationRange = 360.0;
    private static final double theMXRPMConversion = 0.114;
    private static final int theMoveCount = 8;
    private static final byte[] theHeaderData = new byte[]{-1, -1, (byte)DynamixelController.BROADCAST_ID.getIntValue(), 0, Instruction.SyncWrite.getByte(), Register.GoalPosition.getByte(), 4};

    public static boolean moveServos(DynamixelController controller, Collection<MoveParams<DynamixelServo.Id>> params, DynamixelControlSettings settings) {
        if (controller == null || params == null) {
            throw new NullPointerException();
        }
        RXTXSerialPort myPort = controller.getPort();
        if (myPort == null) {
            return false;
        }
        ArrayList<MoveParams<DynamixelServo.Id>> enabled = new ArrayList<MoveParams<DynamixelServo.Id>>();
        for (MoveParams<DynamixelServo.Id> p : params) {
            if (p == null) continue;
            DynamixelServo.Id id = p.getServoId();
            ServoController.ServoId sId = new ServoController.ServoId(controller.getId(), (Object)id);
            DynamixelServo servo = (DynamixelServo)controller.getServo(sId);
            if (servo == null || !servo.getEnabled().booleanValue()) continue;
            enabled.add(p);
        }
        byte[] cmd = DynamixelMover.buildMoveCommand(enabled, settings);
        if (!myPort.write(cmd) || !myPort.flushWriter()) {
            return false;
        }
        for (MoveParams moveParams : enabled) {
            moveParams.goalsSent();
        }
        return true;
    }

    public static byte[] buildMoveCommand(Collection<MoveParams<DynamixelServo.Id>> params, DynamixelControlSettings settings) {
        int jointCount = params.size();
        int paramLen = jointCount * 5;
        int dataSize = paramLen + 8;
        byte[] cmd = new byte[dataSize];
        DynamixelMover.addMoveCommand(params, cmd, 0, settings);
        return cmd;
    }

    private static void addMoveCommand(Collection<MoveParams<DynamixelServo.Id>> params, byte[] cmd, int offset, DynamixelControlSettings settings) {
        int jointCount = params.size();
        int paramLen = jointCount * 5;
        int dataSize = paramLen + 8;
        if (cmd.length < offset + dataSize) {
            throw new IllegalArgumentException("cmd byte array too short.  expected: " + (offset + dataSize) + ", found: " + cmd.length);
        }
        System.arraycopy(theHeaderData, 0, cmd, offset, theHeaderData.length);
        cmd[offset + 3] = (byte)(paramLen + 4);
        DynamixelMover.addServosParams(params, cmd, offset + theHeaderData.length, settings);
        cmd[offset + dataSize - 1] = Utils.checksum((byte[])cmd, (int)(offset + 2), (int)(paramLen + 5), (boolean)true, (byte[])new byte[0]);
    }

    private static void addServosParams(Collection<MoveParams<DynamixelServo.Id>> params, byte[] cmd, int offset, DynamixelControlSettings settings) {
        long now = TimeUtils.now();
        for (MoveParams<DynamixelServo.Id> p : params) {
            int speed = DynamixelMover.calculateSpeed(p, now, settings);
            cmd[offset] = (byte)p.getServoId().getIntValue();
            cmd[offset + 1] = (byte)(p.getGoalPosition() & 0xFF);
            cmd[offset + 2] = (byte)(p.getGoalPosition() >> 8);
            cmd[offset + 3] = (byte)(speed & 0xFF);
            cmd[offset + 4] = (byte)(speed >> 8);
            offset += 5;
        }
        if (theLogger.isTraceEnabled()) {
            for (MoveParams<DynamixelServo.Id> p : params) {
                DynamixelMover.logMoveParam(p);
            }
        }
    }

    private static int calculateSpeed(MoveParams params, long now, DynamixelControlSettings settings) {
        int cur = DynamixelMover.getPositionEstimate(params, now, settings);
        long time = params.getGoalTargetTimeUTC() - now;
        time = (long)((double)time - settings.getCommandSendDelay());
        return DynamixelMover.calculateSpeed(cur, params.getGoalPosition(), time);
    }

    public static int getPositionEstimate(MoveParams params, long now, DynamixelControlSettings settings) {
        long time = now - params.getCurPosTimestampUTC();
        int cur = params.getCurrentPosition() + DynamixelMover.dist(params.getCurrentSpeed(), time);
        cur = params.getCurrentPosition() < params.getPrevGoalPosition() ? Math.min(cur, params.getPrevGoalPosition()) : Math.max(cur, params.getPrevGoalPosition());
        return cur;
    }

    private static int calculateSpeed(int cur, int goal, long time) {
        int dist = Math.abs(goal - cur);
        double theta = (double)dist * 300.0 / 1023.0;
        time = Math.max(time, 1L);
        double rpm = theta * (60000.0 / (double)time) / 360.0;
        double speed = rpm / 0.111;
        return Utils.bound((int)((int)speed), (int)1, (int)1023);
    }

    private static int dist(int speed, long time) {
        speed = Utils.bound((int)speed, (int)-1023, (int)1023);
        time = Math.max(time, 1L);
        double rpm = (double)speed * 0.111;
        double theta = rpm * 360.0 / (60000.0 / (double)time);
        double dist = theta / 300.0 * 1023.0;
        return (int)dist;
    }

    private static void logMoveParam(MoveParams<DynamixelServo.Id> param) {
        theLogger.trace("{},{},{},{},{},{},{},{},{},{},{},{},{}", new Object[]{param.getServoId(), param.getGoalPosition(), param.getGoalTargetTimeUTC(), param.getCurrentPosition(), param.getCurrentSpeed(), param.getCurrentVoltage(), param.getCurrentTemperature(), param.getCurrentLoad(), param.getCurPosTimestampUTC(), param.getPrevGoalPosition(), param.getPrevGoalTargetTimeUTC(), param.getCommandDelayMillisec(), TimeUtils.now()});
    }
}

