/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.openservo.properties;

import org.jflux.api.common.rk.position.IntegerRange;
import org.jflux.api.common.rk.position.NormalizableRange;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.mechio.api.motion.JointProperty;
import org.mechio.impl.motion.openservo.OpenServo;

public class AbsCurrentPositionProperty
extends JointProperty.ReadOnly<Integer> {
    private OpenServo myServo;

    public AbsCurrentPositionProperty(OpenServo servo) {
        if (servo == null) {
            throw new NullPointerException();
        }
        this.myServo = servo;
    }

    public String getPropertyName() {
        return "absCurrentPosition";
    }

    public String getDisplayName() {
        return "Absolute Current Postion";
    }

    public Class<Integer> getPropertyClass() {
        return Integer.class;
    }

    public Integer getValue() {
        double min = this.myServo.getConfig().getMinPosition();
        double max = this.myServo.getConfig().getMaxPosition();
        NormalizedDouble val = this.myServo.getCurrentPosition();
        if (val == null) {
            return null;
        }
        double cur = val.getValue();
        double range = max - min;
        cur = cur * range + min;
        return (int)cur;
    }

    public NormalizableRange<Integer> getNormalizableRange() {
        return new IntegerRange(0, 1023);
    }
}

