/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.dynamixel.properties;

import org.jflux.api.common.rk.position.DoubleRange;
import org.jflux.api.common.rk.position.NormalizableRange;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.jflux.api.common.rk.types.Voltage;
import org.mechio.api.motion.joint_properties.ReadVoltage;
import org.mechio.impl.motion.dynamixel.DynamixelServo;

public class VoltageProperty
extends ReadVoltage {
    private DynamixelServo myDynamixelServo;
    protected Voltage myCachedValue;

    public VoltageProperty(DynamixelServo dyna) {
        if (dyna == null) {
            throw new NullPointerException();
        }
        this.myDynamixelServo = dyna;
    }

    public Voltage getValue() {
        Voltage old = this.myCachedValue;
        this.myCachedValue = this.readValue();
        this.firePropertyChange(this.getPropertyName(), old, this.myCachedValue);
        return this.myCachedValue;
    }

    private Voltage readValue() {
        Integer dynaVoltage = this.myDynamixelServo.getCurrentVoltage();
        if (dynaVoltage != null) {
            double volts = (double)dynaVoltage.intValue() / 10.0;
            return new Voltage(volts);
        }
        return null;
    }

    public NormalizableRange<Voltage> getNormalizableRange() {
        return new NormalizableRange<Voltage>(){
            private DoubleRange myDoubleRange = new DoubleRange(0.0, 1000.0);

            public boolean isValid(Voltage t) {
                return this.myDoubleRange.isValid(Double.valueOf(t.getVolts()));
            }

            public NormalizedDouble normalizeValue(Voltage t) {
                return this.myDoubleRange.normalizeValue(Double.valueOf(t.getVolts()));
            }

            public Voltage denormalizeValue(NormalizedDouble v) {
                return new Voltage(this.myDoubleRange.denormalizeValue(v).doubleValue());
            }

            public Voltage getMin() {
                return new Voltage(this.myDoubleRange.getMin().doubleValue());
            }

            public Voltage getMax() {
                return new Voltage(this.myDoubleRange.getMax().doubleValue());
            }
        };
    }
}

