/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.dynamixel.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.mechio.api.motion.servos.ServoController;
import org.mechio.api.motion.servos.utils.ServoIdReader;
import org.mechio.impl.motion.dynamixel.DynamixelServo;

public class DynamixelServoIdReader
implements ServoIdReader<DynamixelServo.Id> {
    private static final Logger theLogger = Logger.getLogger(DynamixelServoIdReader.class.getName());

    public ServoController.ServoId<DynamixelServo.Id> read(ServoController.Id controllerId, String servoIdStr) {
        if (controllerId == null || servoIdStr == null) {
            throw new NullPointerException();
        }
        DynamixelServo.Id dId = this.read(servoIdStr);
        return new ServoController.ServoId(controllerId, (Object)dId);
    }

    public DynamixelServo.Id read(String servoIdStr) {
        if (servoIdStr == null) {
            throw new NullPointerException();
        }
        try {
            int id = Integer.parseInt(servoIdStr);
            return new DynamixelServo.Id(id);
        }
        catch (NumberFormatException ex) {
            theLogger.log(Level.SEVERE, "Could not read DynamixelServo.Id", ex);
            throw ex;
        }
    }

    public Class<DynamixelServo.Id> getServoIdClass() {
        return DynamixelServo.Id.class;
    }
}

