/*
 * Decompiled with CFR 0.152.
 */
package org.mechio.impl.motion.openservo;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jflux.api.common.rk.utils.Utils;
import org.mechio.impl.motion.openservo.OpenServo;

public class OpenServoPacket {
    private static final Logger theLogger = Logger.getLogger(OpenServoPacket.class.getName());
    private OpenServo.Id myId;
    private byte[] myData;
    private int myLength;
    private boolean myErrorFlag;

    public static OpenServoPacket parsePacket(byte[] data, int offset) {
        boolean dataLen;
        if (data.length - offset < 5) {
            theLogger.log(Level.INFO, "Error reading OpenServo Packet, too few bytes.  Data Length: {0}, offset: {1}\nFull Data: {2}", new Object[]{data.length, offset, Arrays.toString(data)});
            return null;
        }
        int first = Utils.unsign((byte)data[offset]);
        int second = Utils.unsign((byte)data[offset + 1]);
        if (first != 255 || second != 255) {
            theLogger.log(Level.INFO, "Error reading OpenServo Packet.  Incorrect header bytes.Data Length: {0}, offset: {1}, first: {2}, second: {3}", new Object[]{data.length, offset, first, second});
            return null;
        }
        OpenServoPacket packet = new OpenServoPacket();
        int receivedId = Utils.unsign((byte)data[offset + 2]);
        packet.myLength = Utils.unsign((byte)data[offset + 3]) - 1;
        if (packet.myLength > data.length - (offset + 5)) {
            theLogger.log(Level.INFO, "Error reading OpenServo Packet, too few bytes.  Data Length: {0}, Offset: {1}, Packet Length: {2}", new Object[]{data.length, offset, packet.myLength});
            return null;
        }
        int plen = packet.myLength;
        if (plen < 0) {
            theLogger.log(Level.INFO, "Error reading OpenServo Packet.  Negative packet length.");
            return null;
        }
        packet.myData = new byte[packet.myLength];
        System.arraycopy(data, offset + 4, packet.myData, 0, packet.myLength);
        packet.myErrorFlag = packet.myLength != packet.myData.length;
        byte chkCalc = Utils.checksum((byte[])packet.myData, (int)0, (int)packet.myData.length, (boolean)true, (byte[])new byte[]{(byte)receivedId, (byte)(packet.myLength + 1)});
        byte chkRec = data[offset + 4 + packet.myLength];
        boolean chksum = chkCalc != chkRec;
        boolean bl = dataLen = packet.myLength != packet.myData.length;
        if (chksum) {
            theLogger.log(Level.INFO, "Error reading OpenServo packet. Bad checksum.");
            return null;
        }
        if (!packet.myErrorFlag) {
            return packet;
        }
        theLogger.log(Level.INFO, "Bad Packet Received");
        if (chksum) {
            theLogger.log(Level.INFO, "Error reading OpenServo packet. Bad checksum.");
            return packet;
        }
        return packet;
    }

    private OpenServoPacket() {
    }

    public OpenServo.Id getId() {
        return this.myId;
    }

    public byte[] getData() {
        return this.myData;
    }

    public boolean hasError() {
        return this.myErrorFlag;
    }
}

